/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.celleditor.action;

import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.celleditor.IActionCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.action.AbstractOpenDialogCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.properties.celleditor.PropertyDialogCellEditor;
import org.eclipse.papyrus.infra.nattable.properties.messages.Messages;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CreateElementCellEditorButtonAction
extends AbstractOpenDialogCellEditorButtonAction {
    private List<IElementType> elementsForCreation;
    private IElementType selectedElementType = null;
    private EObject creationContext;
    private boolean onlyOnEmptyCell;

    public CreateElementCellEditorButtonAction(List<IElementType> elementsForCreation) {
        this(elementsForCreation, false);
    }

    public CreateElementCellEditorButtonAction(List<IElementType> elementsForCreation, boolean onlyOnEmptyCell) {
        this.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.setText("");
        this.setTooltipText(Messages.CreateNewElementCellEditorButtonAction_CreateNewElement);
        this.elementsForCreation = elementsForCreation;
        this.onlyOnEmptyCell = onlyOnEmptyCell;
    }

    public AbstractDialogCellEditor createDialogCellEditor() {
        return new PropertyDialogCellEditor();
    }

    public int runAction(final SelectionEvent e) {
        this.openMenuForCreation(this.parent);
        if (this.selectedElementType != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            CreateElementRequest request = this.createCreateElementRequest(editingDomain, this.creationContext, this.selectedElementType, null);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.creationContext);
            if (provider != null) {
                final ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
                AbstractTransactionalCommand abs = new AbstractTransactionalCommand(editingDomain, "Create and Edit new element", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                        cmd.execute(arg0, arg1);
                        CommandResult res = cmd.getCommandResult();
                        Object value = res.getReturnValue();
                        Object previousCanonicalValue = CreateElementCellEditorButtonAction.this.originalCanonicalValue;
                        CreateElementCellEditorButtonAction.this.originalCanonicalValue = value;
                        int resIntermediare = CreateElementCellEditorButtonAction.super.runAction(e);
                        if (resIntermediare == 0) {
                            return CommandResult.newOKCommandResult((Object)value);
                        }
                        this.setResult(CommandResult.newCancelledCommandResult());
                        CreateElementCellEditorButtonAction.this.originalCanonicalValue = previousCanonicalValue;
                        return this.getCommandResult();
                    }
                };
                this.getEditingDomain().getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)abs));
                CommandResult res = abs.getCommandResult();
                if (res.getStatus().isOK()) {
                    this.selectedElementType = null;
                    return 0;
                }
            }
        }
        this.selectedElementType = null;
        return 1;
    }

    protected CreateElementRequest createCreateElementRequest(TransactionalEditingDomain editingDomain, EObject container, IElementType elementType, EReference containmentFeature) {
        return new CreateElementRequest(editingDomain, container, elementType, containmentFeature);
    }

    private void openMenuForCreation(Composite parent) {
        if (this.elementsForCreation.size() == 0) {
            return;
        }
        if (this.elementsForCreation.size() == 1) {
            this.selectedElementType = this.elementsForCreation.get(0);
            return;
        }
        Menu menu = new Menu((Control)parent);
        String ELEMENT_TYPE = "elementTypeId";
        for (IElementType current : this.elementsForCreation) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(current.getDisplayName());
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)current.getIconURL());
            item.setImage(Activator.getDefault().getImage(imgDesc));
            item.setData("elementTypeId", (Object)current);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreateElementCellEditorButtonAction.this.setSelectedElementType((IElementType)item.getData("elementTypeId"));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        menu.setVisible(true);
        Display display = Display.getDefault();
        while (menu.isVisible()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    private void setSelectedElementType(IElementType elementType) {
        this.selectedElementType = elementType;
    }

    protected void setCreationContext(EObject creationContext) {
        this.creationContext = creationContext;
    }

    public boolean isEnabled() {
        boolean result;
        boolean bl = result = this.getNattableModelManager() != null && this.creationContext != null && this.elementsForCreation.size() > 0;
        if (result && this.onlyOnEmptyCell) {
            result = this.getCurrentCellValue() == null;
        }
        return result;
    }

    public boolean configureAction(IActionCellEditor editor, Composite parent, Object originalCanonicalValue, ILayerCell cell, IConfigRegistry configRegistry) {
        super.configureAction(editor, parent, originalCanonicalValue, cell, configRegistry);
        if (this.getNattableModelManager() != null && this.getNattableModelManager().getTable() != null) {
            this.creationContext = this.getNattableModelManager().getTable().getOwner();
        }
        return this.isEnabled();
    }
}

