/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.comparator;

import java.text.Collator;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderFullCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.SortLabelProviderFullCellContextElementWrapper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class TableCellLabelProviderComparator
implements Comparator<SortLabelProviderFullCellContextElementWrapper> {
    private final LabelStack stack = new LabelStack(new String[]{"BODY"});
    private final LabelProviderFullCellContextElementWrapper wrapper1 = new LabelProviderFullCellContextElementWrapper();
    private final LabelProviderFullCellContextElementWrapper wrapper2 = new LabelProviderFullCellContextElementWrapper();

    public TableCellLabelProviderComparator() {
        this.wrapper1.setConfigLabels(this.stack);
        this.wrapper2.setConfigLabels(this.stack);
    }

    @Override
    public int compare(SortLabelProviderFullCellContextElementWrapper sortWrapper1, SortLabelProviderFullCellContextElementWrapper sortWrapper2) {
        IConfigRegistry configRegistry = sortWrapper1.getConfigRegistry();
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"label_provider_service_id"});
        String txt1 = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)sortWrapper1);
        String txt2 = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider").getText((Object)sortWrapper2);
        int res = Collator.getInstance().compare(txt1, txt2);
        return res;
    }
}

