/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class EditConfiguration
extends DefaultEditConfiguration {
    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.NORMAL, null);
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)new PapyrusEditableRule(manager));
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, null, DisplayMode.EDIT, "");
    }

    private static final class PapyrusEditableRule
    extends EditableRule {
        private INattableModelManager manager;

        private PapyrusEditableRule(INattableModelManager tableManager) {
            this.manager = tableManager;
        }

        public boolean isEditable(int columnIndex, int rowIndex) {
            Object rowElement = this.manager.getRowElement(rowIndex);
            Object columnElement = this.manager.getColumnElement(columnIndex);
            return CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, this.manager);
        }
    }
}

