/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.filter.IFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractBooleanComboBoxCellEditorFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public abstract class AbstractBooleanFilterRowComboBoxCellEditorFilterConfiguration
extends AbstractBooleanComboBoxCellEditorFilterConfiguration {
    @Override
    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        ICellEditor editor = this.createICellEditor(configRegistry, columnElement, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, this.createMatcherFactory(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(IFilterConfiguration.FILTER_VALUE_TO_MATCH_MANAGER, (Object)this.createBooleanFilterLoader(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getDataValidator(configRegistry), DisplayMode.NORMAL, configLabel);
    }

    protected IFilterValueToMatchManager createBooleanFilterLoader() {
        return new BooleanFilterValueToMatchManager(this.getConfigurationId());
    }

    @Override
    protected ICellEditor createICellEditor(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        IComboBoxDataProvider dataProvider = new IComboBoxDataProvider(){

            public List<?> getValues(int columnIndex, int rowIndex) {
                return availableValue;
            }
        };
        return new FilterRowComboBoxCellEditor(dataProvider);
    }

    @Override
    public String getConfigurationDescription() {
        return "This configuration provides an Combo with checkbox to filter boolean values. Known values are true, false and N/A";
    }

    public static class BooleanFilterValueToMatchManager
    extends AbstractFilterValueToMatchManager {
        public BooleanFilterValueToMatchManager(String filterConfigurationId) {
            super(filterConfigurationId);
        }

        @Override
        public Object getValueToMatch(IConfigRegistry configRegistry, Object axis) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            NamedStyle style = this.getValueToMatchStyle(iaxis);
            if (style != null) {
                String unsupportedColumnCellText = CellHelper.getUnsupportedCellContentsText();
                if (style instanceof StringListValueStyle) {
                    ArrayList<Object> returnedValues = new ArrayList<Object>();
                    EList coll = ((StringListValueStyle)style).getStringListValue();
                    for (String string : coll) {
                        if (string.equals(unsupportedColumnCellText)) {
                            returnedValues.add(unsupportedColumnCellText);
                            continue;
                        }
                        Assert.isTrue((boolean)TypeUtils.isBooleanValue((String)string));
                        returnedValues.add(Boolean.valueOf(string));
                    }
                    return returnedValues;
                }
                if (style instanceof StringValueStyle) {
                    String val = ((StringValueStyle)style).getStringValue();
                    if (val.equals(unsupportedColumnCellText)) {
                        return unsupportedColumnCellText;
                    }
                    Assert.isTrue((boolean)TypeUtils.isBooleanValue((String)val));
                    return Boolean.valueOf(val);
                }
            }
            return null;
        }

        @Override
        protected Command getSaveValueToMatchCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis, Object newValue) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            CompoundCommand cc = new CompoundCommand("Save Value To Match Command");
            NamedStyle keyStyle = this.getValueToMatchStyle(iaxis);
            if (newValue instanceof Collection) {
                Command cmd;
                Collection coll = (Collection)newValue;
                if (keyStyle != null && !(keyStyle instanceof StringListValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createStringListValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Object tmp : coll) {
                    Assert.isTrue((tmp instanceof Boolean || CellHelper.getUnsupportedCellContentsText().equals(tmp) ? 1 : 0) != 0);
                    values.add(tmp.toString());
                }
                cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringListValueStyle_StringListValue(), values));
            } else {
                Command cmd;
                if (keyStyle != null && !(keyStyle instanceof StringValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createEObjectValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                Assert.isTrue((newValue instanceof Boolean || CellHelper.getUnsupportedCellContentsText().equals(newValue) ? 1 : 0) != 0);
                String name = newValue.toString();
                cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)name));
            }
            return cc;
        }
    }
}

