/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public final class RecursionGuard<T> {
    private final Set<T> recursionSet = new HashSet<T>();

    @SafeVarargs
    public final Gate guard(T ... recursionScope) {
        return this.guardIfAny(Objects::nonNull, recursionScope);
    }

    @SafeVarargs
    public final Gate guardIfAny(Predicate<? super T> condition, T ... recursionScope) {
        return new Gate(condition, recursionScope);
    }

    public final class Gate
    implements AutoCloseable {
        private final int size;
        private List<T> gated;

        @SafeVarargs
        private Gate(Predicate<? super T> condition, T ... recursionScope) {
            this.size = recursionScope.length;
            this.gated = new ArrayList(this.size);
            T[] TArray = recursionScope;
            int n = recursionScope.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = TArray[n2];
                if (condition.test(next)) {
                    this.guard(recursionScope);
                }
                ++n2;
            }
        }

        @SafeVarargs
        private void guard(T ... recursionScope) {
            T[] TArray = recursionScope;
            int n = recursionScope.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = TArray[n2];
                if (RecursionGuard.this.recursionSet.add(next)) {
                    this.gated.add(next);
                }
                ++n2;
            }
        }

        public boolean isOpen() {
            return this.gated.size() == this.size;
        }

        @Override
        public void close() {
            RecursionGuard.this.recursionSet.removeAll(this.gated);
            this.gated.clear();
        }
    }
}

