/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.Reference;
import org.eclipse.papyrus.infra.emf.types.constraints.provider.ReferencePermissionItemProvider;

public class ReferenceItemProvider
extends ReferencePermissionItemProvider {
    public ReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addReferencePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addReferencePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Reference_reference_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Reference_reference_feature", "_UI_Reference_type"), (EStructuralFeature)ConstraintAdvicePackage.Literals.REFERENCE__REFERENCE, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                Collection result = super.getChoiceOfValues(object);
                result.removeIf(feature -> feature instanceof EStructuralFeature && ((EStructuralFeature)feature).eContainmentFeature() == EcorePackage.Literals.EANNOTATION__CONTENTS);
                return result;
            }

            public IItemLabelProvider getLabelProvider(Object object) {
                return new IItemLabelProvider(){

                    public String getText(Object value) {
                        if (value instanceof EStructuralFeature) {
                            String typeName;
                            EPackage ePackage;
                            EStructuralFeature feature = (EStructuralFeature)value;
                            EClass eClass = feature.getEContainingClass();
                            EPackage ePackage2 = ePackage = eClass == null ? null : eClass.getEPackage();
                            if (eClass == null || ePackage == null) {
                                return String.format("%s [%s]", feature.getName(), EcoreUtil.getURI((EObject)feature));
                            }
                            EClassifier type = feature.getEType();
                            String string = typeName = type == null ? null : type.getName();
                            if (typeName == null || typeName.isBlank()) {
                                typeName = "void";
                            }
                            return String.format("%s : %s - %s::%s [%s]", feature.getName(), typeName, ePackage.getName(), eClass.getName(), ePackage.getNsURI());
                        }
                        return itemDelegator.getText(value);
                    }

                    public Object getImage(Object value) {
                        return itemDelegator.getImage(value);
                    }
                };
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Reference"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String refName;
        Reference reference = (Reference)object;
        String string = refName = reference.getReference() == null ? null : reference.getReference().getName();
        if (refName == null) {
            return this.getString("_UI_Reference_type") + " " + this.getPermissionModifier(reference);
        }
        return this.getString("_UI_Reference_type") + " '" + refName + "' " + this.getPermissionModifier(reference);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Reference.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

