/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.AbstractGraphicalCreationChecker;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.junit.Assert;

public abstract class AbstractGraphicalEdgeCreationChecker
extends AbstractGraphicalCreationChecker {
    protected final int nbGraphicalEdge;
    protected int expectedAdditionalEdges = 1;

    public AbstractGraphicalEdgeCreationChecker(Diagram diagram, EObject graphicalParent) {
        super(diagram, graphicalParent);
        this.nbGraphicalEdge = diagram.getEdges().size();
    }

    @Override
    protected void checkCreatedElementInstanceOf(DRepresentationElement createdView) {
        Assert.assertTrue((String)NLS.bind((String)"The created element must be a DEdge instead of a {0}.", (Object)createdView.eClass().getName()), (boolean)(createdView instanceof DEdge));
    }

    @Override
    protected void checkCreatedElementMapping(DRepresentationElement createdView) {
        Assert.assertEquals((String)"The mapping is not the expected one.", (Object)this.getEdgeMappingType(), (Object)createdView.getMapping().getName());
        Assert.assertEquals((String)"Parent of the created graphical element is wrong", (Object)this.graphicalParent, (Object)createdView.eContainer());
    }

    @Override
    protected void checkElementsSizes(String phase, boolean done) {
        super.checkElementsSizes(phase, done);
        int newEdges = this.getExpectedAdditionalEdges();
        if (!done) {
            newEdges = 0;
        }
        Assert.assertEquals((String)("Unexpected number of additional edge on " + phase), (long)newEdges, (long)(this.diagram.getEdges().size() - this.nbGraphicalEdge));
    }

    public int getExpectedAdditionalEdges() {
        return this.expectedAdditionalEdges;
    }

    public void setExpectedAdditionalEdges(int expectedEdges) {
        this.expectedAdditionalEdges = expectedEdges;
    }

    protected abstract String getEdgeMappingType();
}

