/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.ConstraintsPackage;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.NameKind;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;

public interface SourceTraceHelper {
    public static final int DEFAULT_MULTIPLICITY = (Integer)ConstraintsPackage.Literals.DISPLAY_UNIT__ELEMENT_MULTIPLICITY.getDefaultValue();

    public EObject getSourceElement(EObject var1);

    public List<? extends EObject> getNestedPackages(EObject var1);

    public List<? extends EObject> getClasses(EObject var1);

    public List<? extends EObject> getProperties(EObject var1);

    public boolean isPropertyRedefinition(EObject var1);

    public List<? extends EObject> getSuperclasses(EObject var1);

    public ConstraintDescriptor createInstanceOfConstraint(EObject var1);

    public boolean isInstanceOfConstraint(ConstraintDescriptor var1);

    public EObject resolveInstanceOfConstraintClass(ConstraintDescriptor var1);

    public String getClassName(ConstraintDescriptor var1);

    public ValueProperty getClassNameProperty(ConstraintDescriptor var1);

    default public Collection<? extends EObject> getValidConstraintSourceClasses(ConstraintDescriptor instanceOfConstraint, EObject sourceClass) {
        return List.of(sourceClass);
    }

    public IGenerator createGenerator(EObject var1);

    default public String getName(EObject sourceElement) {
        return this.getName(sourceElement, NameKind.SIMPLE);
    }

    public String getName(EObject var1, NameKind var2);

    public int getMultiplicity(EObject var1);

    default public boolean isViewOf(View view, DataContextElement element) {
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)view);
        if (!view.getDatacontexts().contains((Object)element)) {
            if (!view.getSections().stream().anyMatch(cache.getSections(element)::contains)) {
                return false;
            }
        }
        return true;
    }

    default public boolean isSectionFor(Section section, DataContextElement element) {
        boolean result = false;
        CompositeWidget widget = section.getWidget();
        if (widget != null && !widget.eIsProxy()) {
            result = Iterators2.stream((TreeIterator)Iterators2.filter((TreeIterator)widget.eAllContents(), PropertyEditor.class)).map(pe -> pe.getProperty()).filter(Objects::nonNull).map(Property::getContextElement).anyMatch(Predicate.isEqual(element));
        }
        return result;
    }
}

