/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.DisplayLabelSwitch;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ILabelConstants;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.LabelServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.OperationServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.PropertyServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.TemplateBindingServices;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class EditLabelSwitch
extends UMLSwitch<Element>
implements ILabelConstants {
    private String editedLabelContent;

    private static ClassifierTemplateParameter createNewClassifierTemplateParameter(TemplateSignature templateSignature, String newTemplateClassName) {
        ClassifierTemplateParameter result = UMLFactory.eINSTANCE.createClassifierTemplateParameter();
        Class newGenericClass = UMLFactory.eINSTANCE.createClass();
        newGenericClass.setName(newTemplateClassName);
        result.setOwnedDefault((ParameterableElement)newGenericClass);
        result.setParameteredElement((ParameterableElement)newGenericClass);
        templateSignature.getOwnedParameters().add((Object)result);
        return result;
    }

    public Element caseActivity(Activity object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseActivityEdge(ActivityEdge object) {
        ValueSpecification expr = object.getGuard();
        if (expr == null || expr instanceof LiteralBoolean) {
            expr = UMLFactory.eINSTANCE.createOpaqueExpression();
            expr.setName(object.getName() + "_guard");
            object.setGuard(expr);
        }
        if (this.editedLabelContent.matches("\\[.*\\]")) {
            this.editedLabelContent = this.editedLabelContent.substring(1, this.editedLabelContent.length() - 1);
        }
        if (expr instanceof OpaqueExpression) {
            ((OpaqueExpression)expr).getBodies().clear();
            ((OpaqueExpression)expr).getBodies().add((Object)this.editedLabelContent);
        }
        return this.caseNamedElement((NamedElement)object);
    }

    public Element caseAssociation(Association object) {
        return object;
    }

    public Element caseBehaviorExecutionSpecification(BehaviorExecutionSpecification execution) {
        this.caseExecutionSpecification((ExecutionSpecification)execution);
        Behavior behavior = execution.getBehavior();
        LabelServices.INSTANCE.editUmlLabel((Element)behavior, this.editedLabelContent);
        Operation operation = (Operation)behavior.getSpecification();
        LabelServices.INSTANCE.editUmlLabel((Element)operation, this.editedLabelContent);
        return execution;
    }

    public Element caseClass(Class object) {
        this.editedLabelContent = this.parseInputLabel((TemplateableElement)object, this.editedLabelContent);
        return this.caseNamedElement((NamedElement)object);
    }

    public Element caseComment(Comment comment) {
        comment.setBody(this.editedLabelContent);
        return comment;
    }

    public Element caseConstraint(Constraint object) {
        this.setEditedLabelContent(this.editedLabelContent);
        this.doSwitch((EObject)object.getSpecification());
        return object;
    }

    public Element caseDataStoreNode(DataStoreNode object) {
        this.editedLabelContent = this.editedLabelContent.replaceFirst("(<<Datastore>>|\u00abDatastore\u00bb)\\s*", "");
        return this.caseNamedElement((NamedElement)object);
    }

    public Element caseEnumerationLiteral(EnumerationLiteral object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseExecutionOccurrenceSpecification(ExecutionOccurrenceSpecification occurence) {
        if (occurence.equals(occurence.getExecution().getStart())) {
            occurence.setName(this.editedLabelContent + "_start");
        } else if (occurence.equals(occurence.getExecution().getFinish())) {
            occurence.setName(this.editedLabelContent + "_finish");
        } else {
            occurence.setName(this.editedLabelContent);
        }
        return occurence;
    }

    public Element caseExecutionSpecification(ExecutionSpecification execution) {
        execution.setName(this.editedLabelContent);
        execution.getStart().setName(this.editedLabelContent + "_start");
        execution.getFinish().setName(this.editedLabelContent + "_finish");
        if (execution.getStart() instanceof MessageOccurrenceSpecification) {
            LabelServices.INSTANCE.editUmlLabel((Element)((MessageOccurrenceSpecification)execution.getStart()).getMessage(), this.editedLabelContent);
        }
        return execution;
    }

    public Element caseFunctionBehavior(FunctionBehavior object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseInteraction(Interaction object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseLifeline(Lifeline lifeline) {
        int indexOfColon = this.editedLabelContent.indexOf(":");
        if (indexOfColon > 0) {
            this.editedLabelContent.substring(0, indexOfColon);
            this.editedLabelContent.substring(indexOfColon + 1, this.editedLabelContent.length()).trim();
        }
        this.caseNamedElement((NamedElement)lifeline);
        ConnectableElement represents = lifeline.getRepresents();
        if (represents instanceof Property) {
            this.caseProperty((Property)represents);
        }
        return lifeline;
    }

    public Element caseMessage(Message message) {
        message.setName(this.editedLabelContent);
        LabelServices.INSTANCE.editUmlLabel((Element)message.getSendEvent(), this.editedLabelContent);
        LabelServices.INSTANCE.editUmlLabel((Element)message.getReceiveEvent(), this.editedLabelContent);
        return message;
    }

    public Element caseMessageOccurrenceSpecification(MessageOccurrenceSpecification occurence) {
        if (occurence.equals(occurence.getMessage().getSendEvent())) {
            occurence.setName(this.editedLabelContent + "_sender");
        } else if (occurence.equals(occurence.getMessage().getReceiveEvent())) {
            occurence.setName(this.editedLabelContent + "_receiver");
        } else {
            occurence.setName(this.editedLabelContent);
        }
        return occurence;
    }

    public Element caseNamedElement(NamedElement object) {
        String stereotype = DisplayLabelSwitch.computeStereotypes((Element)object);
        if (stereotype != null && !"".equals(stereotype)) {
            this.editedLabelContent = this.editedLabelContent.replace(stereotype, "");
        }
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseOpaqueBehavior(OpaqueBehavior object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseOpaqueExpression(OpaqueExpression object) {
        object.getBodies().clear();
        object.getBodies().add((Object)this.editedLabelContent);
        return object;
    }

    public Element caseOperation(Operation object) {
        OperationServices.INSTANCE.parseInputLabel(object, this.editedLabelContent);
        return object;
    }

    public Element caseProperty(Property object) {
        PropertyServices.INSTANCE.parseInputLabel(object, this.editedLabelContent);
        return object;
    }

    public Element caseProtocolStateMachine(ProtocolStateMachine object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseRegion(Region region) {
        int pos = this.editedLabelContent.indexOf(":");
        if (pos > -1) {
            String ownerName = this.editedLabelContent.substring(0, pos).trim();
            if (region.getOwner() instanceof NamedElement) {
                ((NamedElement)region.getOwner()).setName(ownerName);
            }
            region.setName(this.editedLabelContent.substring(pos + 1).trim());
        } else {
            region.setName(this.editedLabelContent.trim());
        }
        return region;
    }

    public void caseRole(Property property) {
        String escapedLabel = this.editedLabelContent;
        if (this.editedLabelContent.indexOf(47) > -1) {
            escapedLabel.replace('/', ' ');
            property.setIsDerived(true);
        } else {
            property.setIsDerived(false);
        }
        escapedLabel = escapedLabel.trim();
        if (escapedLabel.indexOf(91) > -1) {
            String endOfMul = escapedLabel.substring(escapedLabel.indexOf(91) + 1);
            escapedLabel = escapedLabel.substring(0, escapedLabel.indexOf(91));
            escapedLabel = escapedLabel.trim();
            int lowerBound = property.getLower();
            int upperBound = property.getUpper();
            if (endOfMul.indexOf(93) > -1) {
                String mulInter = endOfMul.substring(0, endOfMul.indexOf(93)).trim();
                if ("*".equals(mulInter)) {
                    lowerBound = 0;
                    upperBound = -1;
                } else if (mulInter.length() > 0) {
                    if (mulInter.indexOf("..") > -1) {
                        String up;
                        String low = mulInter.substring(0, mulInter.indexOf("..")).trim();
                        if (low.length() > 0) {
                            lowerBound = Integer.valueOf(low);
                        }
                        if ((up = mulInter.substring(mulInter.indexOf("..") + 2).trim()).length() > 0) {
                            upperBound = "*".equals(up) ? -1 : Integer.valueOf(up);
                        }
                    } else {
                        int singleBound;
                        lowerBound = singleBound = Integer.valueOf(mulInter).intValue();
                        upperBound = singleBound;
                    }
                }
            }
            property.setLower(lowerBound);
            property.setUpper(upperBound);
        }
        property.setName(escapedLabel);
    }

    public Element caseSlot(Slot slot) {
        for (ValueSpecification value : slot.getValues()) {
            if (value instanceof InstanceValue) {
                this.caseInstanceValue((InstanceValue)value);
                continue;
            }
            if (value instanceof LiteralInteger) {
                this.caseLiteralInteger((LiteralInteger)value);
                continue;
            }
            if (value instanceof LiteralBoolean) {
                this.caseLiteralBoolean((LiteralBoolean)value);
                continue;
            }
            if (!(value instanceof LiteralString)) continue;
            this.caseLiteralString((LiteralString)value);
        }
        return slot;
    }

    public Element caseStateMachine(StateMachine object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseTemplateableElement(TemplateableElement object) {
        this.editedLabelContent = this.parseInputLabel(object, this.editedLabelContent);
        return (Element)super.caseTemplateableElement(object);
    }

    public Element caseTemplateBinding(TemplateBinding object) {
        TemplateBindingServices.INSTANCE.parseInputLabel(object, this.editedLabelContent);
        this.editedLabelContent = (String)new DisplayLabelSwitch().doSwitch((EObject)object);
        return object;
    }

    public Element caseTransition(Transition object) {
        String newLabel = this.editedLabelContent;
        this.editTransitionGuard(object, newLabel);
        this.editTransitionBehaviorExpression(object, newLabel);
        this.editTransitionTrigger(object, newLabel);
        return object;
    }

    public Element caseTrigger(Trigger object) {
        object.setName(this.editedLabelContent);
        return object;
    }

    public Element caseTypedElement(TypedElement object) {
        String[] splittedLabel = this.editedLabelContent.split("\\s*:\\s*");
        if (splittedLabel.length == 1) {
            return this.caseNamedElement((NamedElement)object);
        }
        object.setName(splittedLabel[0]);
        return object;
    }

    private void editTransitionBehaviorExpression(Transition object, String newLabel) {
        int behaviorStartIndex = newLabel.lastIndexOf("/");
        if (behaviorStartIndex != -1) {
            String behaviorLabelContent;
            int guardEndIndex = -1;
            if (newLabel.matches(".*\\[.*\\].*")) {
                guardEndIndex = newLabel.lastIndexOf("]");
            }
            if (behaviorStartIndex > guardEndIndex && !(behaviorLabelContent = newLabel.substring(behaviorStartIndex + 1)).isEmpty()) {
                Behavior effect = object.getEffect();
                if (effect == null) {
                    effect = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    object.setEffect(effect);
                }
                this.setEditedLabelContent(behaviorLabelContent);
                this.doSwitch((EObject)effect);
            }
        } else if (object.getEffect() != null) {
            object.getEffect().destroy();
        }
    }

    private void editTransitionGuard(Transition object, String newLabel) {
        int guardStartIndex = newLabel.indexOf("[");
        if (newLabel.matches(".*\\[.*\\].*")) {
            String editedGuardLabelContent = newLabel;
            int guardEndIndex = editedGuardLabelContent.lastIndexOf("]");
            if (!(editedGuardLabelContent = editedGuardLabelContent.substring(guardStartIndex + 1, guardEndIndex)).isEmpty()) {
                Constraint constraint = object.getGuard();
                if (constraint == null) {
                    constraint = UMLFactory.eINSTANCE.createConstraint();
                    constraint.setName(object.getName() + "_transition");
                    OpaqueExpression expr = UMLFactory.eINSTANCE.createOpaqueExpression();
                    expr.setName(object.getName() + "_guard");
                    constraint.setSpecification((ValueSpecification)expr);
                    object.setGuard(constraint);
                }
                this.setEditedLabelContent(editedGuardLabelContent);
                this.doSwitch((EObject)constraint);
            }
        } else if (object.getGuard() != null) {
            object.getGuard().destroy();
        }
    }

    private void editTransitionTrigger(Transition object, String newLabel) {
        block13: {
            block12: {
                int guardStartIndex = newLabel.indexOf("[");
                int behaviorStartIndex = newLabel.lastIndexOf("/");
                int triggerEndIndex = -1;
                if (behaviorStartIndex >= 0 && guardStartIndex >= 0) {
                    triggerEndIndex = guardStartIndex;
                    if (guardStartIndex > behaviorStartIndex) {
                        triggerEndIndex = behaviorStartIndex;
                    }
                } else {
                    triggerEndIndex = behaviorStartIndex != -1 ? behaviorStartIndex : (guardStartIndex != -1 ? guardStartIndex : newLabel.length());
                }
                ArrayList<String> triggersLabels = new ArrayList<String>();
                if (!newLabel.isEmpty() && triggerEndIndex > 0) {
                    String triggerEditedLabel = newLabel.substring(0, triggerEndIndex);
                    if (triggerEditedLabel.contains(",")) {
                        triggersLabels.addAll(Arrays.asList(triggerEditedLabel.split(",")));
                    } else {
                        triggersLabels.add(triggerEditedLabel);
                    }
                }
                if (triggersLabels.size() <= 0) break block12;
                ArrayList<String> existingTriggersNames = new ArrayList<String>();
                for (Trigger trigger : object.getTriggers()) {
                    existingTriggersNames.add(trigger.getName());
                }
                ArrayList<String> toBeCreated = new ArrayList<String>();
                for (String label : triggersLabels) {
                    if (existingTriggersNames.contains(label.trim())) {
                        existingTriggersNames.remove(label.trim());
                        continue;
                    }
                    toBeCreated.add(label.trim());
                }
                for (String label : existingTriggersNames) {
                    object.getTrigger(label).destroy();
                }
                for (String label : toBeCreated) {
                    Trigger trigger = UMLFactory.eINSTANCE.createTrigger();
                    object.getTriggers().add((Object)trigger);
                    this.setEditedLabelContent(label.trim());
                    this.doSwitch((EObject)trigger);
                }
                break block13;
            }
            EList triggers = object.getTriggers();
            if (triggers.size() <= 0) break block13;
            for (Trigger trigger : triggers) {
                trigger.destroy();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String parseInputLabel(TemplateableElement aTemplateableElement, String inputLabel) {
        result = inputLabel;
        validLabel = "[a-zA-Z_0-9]+((\\s)*<[a-zA-Z_0-9]+(,(\\s)*[a-zA-Z_0-9]+)*>)?";
        templatedLabel = "[a-zA-Z_0-9]+((\\s)*<[a-zA-Z_0-9]+(,(\\s)*[a-zA-Z_0-9]+)*>)";
        if (inputLabel.matches("[a-zA-Z_0-9]+((\\s)*<[a-zA-Z_0-9]+(,(\\s)*[a-zA-Z_0-9]+)*>)?")) {
            if (inputLabel.matches("[a-zA-Z_0-9]+((\\s)*<[a-zA-Z_0-9]+(,(\\s)*[a-zA-Z_0-9]+)*>)") && aTemplateableElement instanceof Classifier) {
                splittedLabel = inputLabel.split("(\\s)*<");
                result = splittedLabel[0].trim();
                templateSignatureLabel = splittedLabel[1].replace(">", "");
                templateParamLabels = templateSignatureLabel.split(",(\\s)*");
                templateSignature = aTemplateableElement.getOwnedTemplateSignature();
                if (templateSignature == null) {
                    templateSignature = aTemplateableElement.createOwnedTemplateSignature();
                }
                templateParameters = templateSignature.getOwnedParameters();
                i = 0;
                while (i < templateParamLabels.length) {
                    block12: {
                        templateParamLabel = templateParamLabels[i].trim();
                        try {
                            templateParameter = (TemplateParameter)templateParameters.get(i);
                            if (!(templateParameter.getParameteredElement() instanceof NamedElement)) break block12;
                            ((NamedElement)templateParameter.getParameteredElement()).setName(templateParamLabel);
                            break block12;
                        }
                        catch (IndexOutOfBoundsException e) {
                            createNewClassifierTemplateParameter = EditLabelSwitch.createNewClassifierTemplateParameter(templateSignature, templateParamLabel);
                            sess = SessionManager.INSTANCE.getSession((EObject)templateSignature);
                            inverseReferences = sess.getSemanticCrossReferencer().getInverseReferences((EObject)templateSignature);
                            ** for (setting : inverseReferences)
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (!(setting.getEObject() instanceof TemplateBinding)) continue;
                            templateBinding = (TemplateBinding)setting.getEObject();
                            templateParameterSubstitution = templateBinding.createParameterSubstitution();
                            templateParameterSubstitution.setFormal((TemplateParameter)createNewClassifierTemplateParameter);
                            continue;
                        }
                    }
                    ++i;
                }
                while (templateParamLabels.length < templateParameters.size()) {
                    templateParameterToRemove = (TemplateParameter)templateParameters.get(templateParameters.size() - 1);
                    sess = SessionManager.INSTANCE.getSession((EObject)templateParameterToRemove);
                    inverseReferences = sess.getSemanticCrossReferencer().getInverseReferences((EObject)templateParameterToRemove);
                    for (EStructuralFeature.Setting setting : inverseReferences) {
                        if (!(setting.getEObject() instanceof TemplateParameterSubstitution)) continue;
                        templateParameterSubstitution = (TemplateParameterSubstitution)setting.getEObject();
                        templateBinding = templateParameterSubstitution.getTemplateBinding();
                        templateBinding.getParameterSubstitutions().remove((Object)templateParameterSubstitution);
                        templateParameterSubstitution = null;
                    }
                    templateSignature.getParameters().remove((Object)templateParameterToRemove);
                }
            } else {
                templateSignature = aTemplateableElement.getOwnedTemplateSignature();
                if (templateSignature != null) {
                    sess = SessionManager.INSTANCE.getSession((EObject)templateSignature);
                    inverseReferences = sess.getSemanticCrossReferencer().getInverseReferences((EObject)templateSignature);
                    for (EStructuralFeature.Setting setting : inverseReferences) {
                        if (!(setting.getEObject() instanceof TemplateBinding)) continue;
                        templateBinding = (TemplateBinding)setting.getEObject();
                        templateBinding.getParameterSubstitutions().clear();
                        templateBinding.setSignature(null);
                        boundElement = templateBinding.getBoundElement();
                        boundElement.setOwnedTemplateSignature(null);
                        boundElement.getTemplateBindings().clear();
                    }
                    templateSignature.getParameters().clear();
                    templateSignature.getOwnedParameters().clear();
                    ((ParameterableElement)aTemplateableElement).setTemplateParameter(null);
                    aTemplateableElement.setOwnedTemplateSignature(null);
                }
            }
        }
        return result;
    }

    public void setEditedLabelContent(String editedLabelContent) {
        this.editedLabelContent = editedLabelContent;
    }
}

