/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.extensionpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class GeneratorExtensionPoint {
    private final String EXTENSION_ID = "org.eclipse.papyrus.customization.properties.generation.generator";
    private final List<IGenerator> generators;

    public GeneratorExtensionPoint() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.customization.properties.generation.generator");
        ArrayList<IGenerator> generators = new ArrayList<IGenerator>(2);
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String generatorClassName = e.getAttribute("generator");
            IGenerator generator = (IGenerator)ClassLoaderHelper.newInstance((String)generatorClassName, IGenerator.class);
            if (generator == null) {
                Activator.log.warn("Cannot instantiate the generator : " + generatorClassName);
            } else {
                generators.add(generator);
            }
            ++n2;
        }
        this.generators = Collections.unmodifiableList(generators);
    }

    public List<IGenerator> getGenerators() {
        return this.generators;
    }
}

