/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor.palette;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;
import xpt.editor.palette.Utils_qvto;

@Singleton
public class PaletteConfiguration {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;

    public CharSequence PaletteConfiguration(GenEditorGenerator it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"ASCII\"?>");
        _builder.newLine();
        CharSequence _xmlGeneratedTag = this._common.xmlGeneratedTag();
        _builder.append((Object)_xmlGeneratedTag);
        _builder.newLineIfNotEmpty();
        _builder.append("<paletteconfiguration:PaletteConfiguration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xmlns:paletteconfiguration=\"http://www.eclipse.org/papyrus/diagram/paletteconfiguration/0.8\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xmlns:elementtypesconfigurations=\"http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.2\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=\"");
        String _iD = it.getPlugin().getID();
        _builder.append(_iD, "\t");
        _builder.append(".paletteconfiguration\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        String _name = it.getPlugin().getName();
        _builder.append(_name, "\t");
        _builder.append(" Palette\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("description=\"This is the palette of ");
        String _name_1 = it.getPlugin().getName();
        _builder.append(_name_1, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList _groups = it.getDiagram().getPalette().getGroups();
        for (ToolGroup tool : _groups) {
            _builder.append("\t");
            CharSequence _addDrawerConfigurations = this.addDrawerConfigurations(tool);
            _builder.append((Object)_addDrawerConfigurations, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</paletteconfiguration:PaletteConfiguration>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addDrawerConfigurations(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<drawerConfigurations");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=");
        boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
        if (_isQuoted) {
            String _id = it.getId();
            _builder.append(_id, "\t");
        } else {
            _builder.append("\"");
            String _id_1 = it.getId();
            _builder.append(_id_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        String _title = it.getTitle();
        _builder.append(_title, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("description=\"");
        String _description = it.getDescription();
        _builder.append(_description, "\t");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<icon pluginID=\"");
        String _retrieveBundleId = this._utils_qvto.retrieveBundleId(it.getSmallIconPath(), it.getPalette().getDiagram().getEditorGen().getPlugin().getID());
        _builder.append(_retrieveBundleId, "\t");
        _builder.append("\" iconPath=\"");
        String _retrieveLocalPath = this._utils_qvto.retrieveLocalPath(it.getSmallIconPath());
        _builder.append(_retrieveLocalPath, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        EList _entries = it.getEntries();
        for (ToolGroupItem entry : _entries) {
            if (entry instanceof ToolEntry && this._utils_qvto.isValidTool((AbstractToolEntry)entry)) {
                _builder.append("\t");
                CharSequence _addToolConfiguration = this.addToolConfiguration((ToolEntry)entry);
                _builder.append((Object)_addToolConfiguration, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (!(entry instanceof ToolGroup)) continue;
            _builder.append("\t");
            CharSequence _addStackConfiguration = this.addStackConfiguration((ToolGroup)entry);
            _builder.append((Object)_addStackConfiguration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</drawerConfigurations>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addToolConfiguration(ToolEntry it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<ownedConfigurations xsi:type=\"paletteconfiguration:ToolConfiguration\"");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("id=");
        boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
        if (_isQuoted) {
            String _id = it.getId();
            _builder.append(_id, "\t");
        } else {
            _builder.append("\"");
            String _id_1 = it.getId();
            _builder.append(_id_1, "\t");
            _builder.append("\"");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        String _title = it.getTitle();
        _builder.append(_title, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        if (it.getQualifiedToolName() != null && !it.getQualifiedToolName().isEmpty()) {
            _builder.append("\t");
            _builder.append("toolClassName=\"");
            String _qualifiedToolName = it.getQualifiedToolName();
            _builder.append(_qualifiedToolName, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("description=\"");
        String _description = it.getDescription();
        _builder.append(_description, "\t");
        _builder.append("\"");
        if (it.getGenNodes().isEmpty() && !it.getGenLinks().isEmpty()) {
            _builder.append(" kind=\"ConnectionTool\"");
        }
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<icon pluginID=\"");
        String _retrieveBundleId = this._utils_qvto.retrieveBundleId(it.getSmallIconPath(), it.getGroup().getPalette().getDiagram().getEditorGen().getPlugin().getID());
        _builder.append(_retrieveBundleId, "\t");
        _builder.append("\" iconPath=\"");
        String _retrieveLocalPath = this._utils_qvto.retrieveLocalPath(it.getSmallIconPath());
        _builder.append(_retrieveLocalPath, "\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        if (it.getElements().isEmpty() && (it.getQualifiedToolName() == null || it.getQualifiedToolName().isEmpty())) {
            _builder.append("\t");
            String _title_1 = it.getTitle();
            String _plus = "No elements for tool generation (Palette):" + _title_1;
            this._common_qvto.ERROR(_plus);
            _builder.newLineIfNotEmpty();
        }
        EList _elements = it.getElements();
        for (GenCommonBase e : _elements) {
            _builder.append("\t");
            Resource _eResource = it.eResource();
            String href = this._utils_qvto.getElementTypeConfHRef(e.getElementType().getUniqueIdentifier(), (XMLResource)_eResource);
            _builder.newLineIfNotEmpty();
            if (href != null && !href.isEmpty()) {
                _builder.append("\t");
                _builder.append("<elementDescriptors>");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("<elementType");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("xsi:type=\"");
                Resource _eResource_1 = it.eResource();
                String _configurationXsiType = this._utils_qvto.getConfigurationXsiType(e.getElementType().getUniqueIdentifier(), (XMLResource)_eResource_1);
                _builder.append(_configurationXsiType, "\t\t\t");
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("href=\"");
                _builder.append(href, "\t\t\t");
                _builder.append("\"/>");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("</elementDescriptors>");
                _builder.newLine();
                continue;
            }
            if (it.getQualifiedToolName() != null && !it.getQualifiedToolName().isEmpty()) continue;
            _builder.append("\t");
            String _title_2 = it.getTitle();
            String _plus_1 = "No element type configuration or classToolName for tool generation (Palette):" + _title_2;
            this._common_qvto.ERROR(_plus_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</ownedConfigurations>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addStackConfiguration(ToolGroup it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<ownedConfigurations xsi:type=\"paletteconfiguration:StackConfiguration\" id=");
        boolean _isQuoted = this._utils_qvto.isQuoted(it.getId(), "\"");
        if (_isQuoted) {
            String _id = it.getId();
            _builder.append(_id);
        } else {
            _builder.append("\"");
            String _id_1 = it.getId();
            _builder.append(_id_1);
            _builder.append("\"");
        }
        _builder.append(" label=\"");
        String _title = it.getTitle();
        _builder.append(_title);
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList _entries = it.getEntries();
        for (ToolGroupItem entry : _entries) {
            if (!(entry instanceof ToolEntry) || !this._utils_qvto.isValidTool((AbstractToolEntry)entry)) continue;
            _builder.append("\t");
            CharSequence _addToolConfiguration = this.addToolConfiguration((ToolEntry)entry);
            _builder.append((Object)_addToolConfiguration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</ownedConfigurations>");
        _builder.newLine();
        return _builder;
    }
}

