/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.create.ICreator;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class CommonDiagramServices
extends AbstractDiagramServices {
    @Deprecated
    public static EObject debugVsm(EObject it, String hint) {
        String message = "Debug VSM[" + hint + "]: " + String.valueOf(it);
        System.out.println(message);
        ((Session)Session.of((EObject)it).get()).getInterpreter().getVariables().forEach((key, value) -> {
            String variable = "\t" + key + " = " + String.valueOf(value);
            System.out.println(variable);
        });
        return it;
    }

    public boolean isCompartmentView(DSemanticDecorator view) {
        return this.isCompartment(view);
    }

    public EObject createElement(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        ElementCreator elementCreator = new ElementCreator((IElementConfigurer)new ElementConfigurer(), (IFeatureModifier)new ElementFeatureModifier(this.getECrossReferenceAdapter((EObject)parent), (IEditableChecker)new EditableChecker()));
        return this.createElement(parent, type, referenceName, targetView, (ICreator)elementCreator);
    }

    public EObject createElement(Element parent, String type, String referenceName, DSemanticDecorator targetView, ICreator creator) {
        EObject result;
        if (parent == null) {
            Activator.log.warn("Unable to create an element on nothing");
            result = null;
        } else {
            CreationStatus status = creator.create((EObject)parent, type, referenceName);
            result = status.getElement();
            if (status.getState() == State.FAILED) {
                Activator.log.warn("Creation failed : " + status.getMessage());
            } else if (result != null) {
                Session session = SessionManager.INSTANCE.getSession((EObject)parent);
                DSemanticDecorator containerView = targetView;
                String containerViewExpression = "aql:containerView";
                if (this.isCompartment(containerView) && this.isBorderNode(result, (DSemanticDecorator)targetView.eContainer())) {
                    containerView = (DSemanticDecorator)targetView.eContainer();
                    containerViewExpression = "aql:containerView.eContainer()";
                }
                this.createView(result, containerView, session, containerViewExpression);
            }
        }
        return result;
    }

    public boolean isGraphicalElementOutsideOfItsSemanticContainer(Element element, DSemanticDecorator graphicalElement) {
        EObject target;
        EObject graphicalContainer = graphicalElement.eContainer();
        if (graphicalContainer instanceof DSemanticDecorator && (target = ((DSemanticDecorator)graphicalContainer).getTarget()) != null) {
            if (target == element.eContainer()) {
                return false;
            }
            if (target instanceof Property && ((Property)target).getType() == element.eContainer()) {
                return false;
            }
        }
        return true;
    }

    public boolean isTypeOf(Element element, String type) {
        return Objects.equals(UMLHelper.toEClass((String)type), element.eClass());
    }
}

