/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests.apireport;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.papyrus.bundles.tests.Activator;
import org.eclipse.papyrus.bundles.tests.BundleTestsUtils;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APIReportGenerator {
    private static AtomicInteger nextDevWorkspaceBundleID = new AtomicInteger(Integer.MAX_VALUE);
    private final Pattern bundleLocation = Pattern.compile("([^:]+:)?file:(.*)");
    private final File baselineLocation;
    private final File apiXML;

    public APIReportGenerator(File baselineLocation, File apiXML) {
        this.baselineLocation = baselineLocation;
        this.apiXML = apiXML;
    }

    /*
     * Exception decompiling
     */
    public IStatus generate(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    IApiBaseline getBaseline(final Pattern[] exclusionPatterns, final IProgressMonitor monitor) throws IOException, CoreException {
        final IApiBaseline result = ApiModelFactory.newApiBaseline((String)"Configured Baseline");
        final ArrayList components = new ArrayList();
        Files.walkFileTree(Paths.get(this.baselineLocation.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
            private boolean inPlugins;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result2 = FileVisitResult.CONTINUE;
                if (this.inPlugins) {
                    result2 = FileVisitResult.SKIP_SUBTREE;
                } else if ("plugins".equals(dir.getFileName().toString())) {
                    this.inPlugins = true;
                }
                return result2;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileVisitResult result2 = FileVisitResult.CONTINUE;
                if ("plugins".equals(dir.getFileName().toString())) {
                    this.inPlugins = false;
                    result2 = FileVisitResult.TERMINATE;
                }
                return result2;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (this.inPlugins) {
                    try {
                        IApiComponent component = ApiModelFactory.newApiComponent((IApiBaseline)result, (String)file.toString());
                        if (component != null && !APIReportGenerator.isExcluded(exclusionPatterns, component.getSymbolicName())) {
                            components.add(component);
                            monitor.subTask(" added component " + component.getSymbolicName());
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                System.out.printf("Error visiting %s: %s%n", file, exc.getMessage());
                return FileVisitResult.CONTINUE;
            }
        });
        result.addApiComponents(components.toArray(new IApiComponent[components.size()]));
        return result;
    }

    private static boolean isExcluded(Pattern[] patterns, String name) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(name);
            if (matcher.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ApiScope getAPIToCompare(Pattern[] exclusionPatterns, IProgressMonitor monitor) throws CoreException {
        ApiScope result = new ApiScope();
        IApiBaseline currentBaseline = ApiModelFactory.newApiBaseline((String)"Test Baseline");
        if (currentBaseline != null) {
            for (Bundle next : BundleTestsUtils.getPapyrusBundles()) {
                if ((next.getState() & 0x2A) == 0 || APIReportGenerator.isExcluded(exclusionPatterns, next.getSymbolicName())) continue;
                try {
                    String installLocation = this.getInstallLocation(next);
                    if (installLocation == null) continue;
                    IApiComponent component = null;
                    Path installPath = Paths.get(installLocation, new String[0]);
                    Path dotClasspath = installPath.resolve(".classpath");
                    component = Files.isDirectory(installPath, new LinkOption[0]) && Files.exists(dotClasspath, new LinkOption[0]) ? this.createDevWorkspaceComponent(currentBaseline, installPath, dotClasspath) : ApiModelFactory.newApiComponent((IApiBaseline)currentBaseline, (String)installLocation);
                    if (component == null) continue;
                    result.addElement((IApiElement)component);
                    monitor.subTask(" added component " + component.getSymbolicName());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            List<IApiComponent> allComponents = Stream.of(result.getApiElements()).filter(IApiComponent.class::isInstance).map(IApiComponent.class::cast).collect(Collectors.toList());
            currentBaseline.addApiComponents(allComponents.toArray(new IApiComponent[allComponents.size()]));
        }
        return result;
    }

    String getInstallLocation(Bundle bundle) {
        String result = null;
        Matcher m = this.bundleLocation.matcher(bundle.getLocation());
        if (m.matches()) {
            result = new File(m.group(2)).getAbsolutePath();
        }
        return result;
    }

    protected IApiComponent createDevWorkspaceComponent(IApiBaseline parent, Path installLocation, final Path dotClasspath) throws CoreException {
        BundleComponent result = new BundleComponent(parent, installLocation.toString(), APIReportGenerator.nextDevWorkspaceBundleID()){

            protected String[] getClasspathEntries(Map<String, String> manifest) throws BundleException {
                List<String> classpathEntries = APIReportGenerator.this.parseClasspath(dotClasspath);
                return classpathEntries.toArray(new String[classpathEntries.size()]);
            }
        };
        return result;
    }

    private static int nextDevWorkspaceBundleID() {
        return nextDevWorkspaceBundleID.getAndDecrement();
    }

    protected List<String> parseClasspath(Path dotClasspath) throws BundleException {
        final ArrayList<String> result = new ArrayList<String>();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(dotClasspath.toFile(), new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    block9: {
                        String kind;
                        if (!"classpathentry".equals(qName) || (kind = attributes.getValue("kind")) == null) break block9;
                        switch (kind) {
                            case "output": 
                            case "lib": {
                                result.add(attributes.getValue("path"));
                            }
                        }
                    }
                }
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new BundleException("Failed to parse bundle classpath", (Throwable)e);
        }
        return result;
    }

    private static void checkCancellation(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static Pattern[] loadExclusions(String resourceName) {
        List<Pattern> result;
        URL url = APIReportGenerator.class.getResource(resourceName);
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader input = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                result = input.lines().map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).filter(line -> !line.startsWith("#")).map(pattern -> {
                    pattern = pattern.startsWith("R:") ? pattern.substring("R:".length()) : Pattern.quote(pattern);
                    return Pattern.compile(pattern);
                }).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result = Collections.emptyList();
        }
        return result.toArray(new Pattern[result.size()]);
    }
}

