/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.directedit;

import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.papyrus.uml.diagram.common.directedit.ILabelControler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class LabelDirectEditManager
extends DirectEditManager {
    protected static IActionBars actionBars;
    protected CellEditorActionHandler actionHandler;
    protected static IAction copy;
    protected static IAction cut;
    protected static IAction paste;
    protected static IAction undo;
    protected static IAction redo;
    protected static IAction find;
    protected static IAction selectAll;
    protected static IAction delete;
    protected ILabelControler labelCtrl;

    public LabelDirectEditManager(GraphicalEditPart source, CellEditorLocator locator, ILabelControler labelCtrl) {
        super(source, null, locator);
        this.labelCtrl = labelCtrl;
    }

    protected void bringDown() {
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (actionBars != null) {
            this.restoreSavedActions(actionBars);
            actionBars.updateActionBars();
            actionBars = null;
        }
        super.bringDown();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 0x1000000);
    }

    protected DirectEditRequest createDirectEditRequest() {
        DirectEditRequest req = new DirectEditRequest();
        req.setCellEditor(this.getCellEditor());
        req.setDirectEditFeature((Object)this.labelCtrl);
        return req;
    }

    protected void initCellEditor() {
        this.getCellEditor().setValue((Object)this.labelCtrl.getPropertyAccessor().getValue());
        this.getCellEditor().getControl().setFont(this.labelCtrl.getLabel().getFont());
        IActionBars editorActionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        if (actionBars != null) {
            this.restoreSavedActions(editorActionBars);
        }
        this.saveCurrentActions(editorActionBars);
        actionBars = editorActionBars;
        this.actionHandler = new CellEditorActionHandler(actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        actionBars.updateActionBars();
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }
}

