/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.nattableconfiguration.edition;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.customization.nattableconfiguration.messages.Messages;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.CompoundFilteredRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FeatureFillingConfigurationDialog
extends SelectionDialog {
    protected final EStructuralFeatureValueFillingConfiguration modifiedFeatureFillingConf;
    protected final ILabelProvider labelProvider;
    protected CLabel listenFeatureText;
    protected Button browseValuesButton;
    protected Button deleteValuesButton;

    public FeatureFillingConfigurationDialog(Shell parentShell, EStructuralFeatureValueFillingConfiguration featureFillingConf) {
        super(parentShell);
        this.modifiedFeatureFillingConf = (EStructuralFeatureValueFillingConfiguration)EcoreUtil.copy((EObject)featureFillingConf);
        this.setTitle(Messages.FeatureFillingConfigurationDialog_featureFillingConfigurationDialogName);
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.labelProvider = labelProviderService.getLabelProvider();
    }

    public void create() {
        super.create();
        this.getShell().setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
        Composite parent = new Composite((Composite)this.getDialogArea(), 0);
        parent.setLayout((Layout)new GridLayout(4, false));
        parent.setLayoutData((Object)new GridData(4, 1, true, false));
        this.getShell().setSize(600, 400);
        this.createFields(parent);
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int minWidth = 600;
        if (size.x < minWidth) {
            size.x = minWidth;
        }
        this.getShell().setSize(size);
    }

    protected void createFields(Composite parent) {
        Label listenFeatureLabel = new Label(parent, 0);
        listenFeatureLabel.setText(Messages.FeatureFillingConfigurationDialog_listenFeature);
        listenFeatureLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.listenFeatureText = new CLabel(parent, 2048);
        this.listenFeatureText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.browseValuesButton = new Button(parent, 8);
        this.browseValuesButton.setImage(Activator.getDefault().getImage("/icons/browse_12x12.gif"));
        this.browseValuesButton.setToolTipText(org.eclipse.papyrus.infra.widgets.messages.Messages.ReferenceDialog_EditValue);
        this.browseValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureFillingConfigurationDialog.this.browseAction(FeatureFillingConfigurationDialog.this.modifiedFeatureFillingConf.getListenFeature());
            }
        });
        this.deleteValuesButton = new Button(parent, 8);
        this.deleteValuesButton.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.deleteValuesButton.setToolTipText(org.eclipse.papyrus.infra.widgets.messages.Messages.ReferenceDialog_UnsetValue);
        this.deleteValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureFillingConfigurationDialog.this.setListenFeature(null);
            }
        });
        this.setListenFeature(this.modifiedFeatureFillingConf.getListenFeature());
    }

    protected void browseAction(Object value) {
        int result;
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell()){

            protected void initViewerAndProvider() {
                super.initViewerAndProvider();
                this.getViewer().setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        dialog.setTitle(Messages.FeatureFillingConfigurationDialog_listenFeatureDialogName);
        CompoundFilteredRestrictedContentProvider contentProvider = new CompoundFilteredRestrictedContentProvider();
        ReferenceSelector selector = new ReferenceSelector(false){

            public void createControls(Composite parent) {
                super.createControls(parent);
                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        selector.setLabelProvider(this.labelProvider);
        selector.setContentProvider((IStaticContentProvider)contentProvider);
        FlattenableRestrictedFilteredContentProvider treeContentProvider = new FlattenableRestrictedFilteredContentProvider((IRestrictedContentProvider)contentProvider, selector){

            public boolean isValidValue(Object element) {
                return element instanceof EReference && ((EReference)element).isMany() && element != EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
            }
        };
        dialog.setContentProvider((ITreeContentProvider)treeContentProvider);
        dialog.setLabelProvider(this.labelProvider);
        if (value != null) {
            dialog.setInitialElementSelections(Collections.singletonList(value));
        }
        if ((result = dialog.open()) == 0) {
            Object[] newValue = dialog.getResult();
            if (newValue == null) {
                return;
            }
            if (newValue.length == 0) {
                this.setListenFeature(null);
            } else {
                this.setListenFeature((EStructuralFeature)newValue[0]);
            }
        }
    }

    protected void setListenFeature(EStructuralFeature structuralFeature) {
        if (this.modifiedFeatureFillingConf.getListenFeature() == null || !structuralFeature.equals(this.modifiedFeatureFillingConf.getListenFeature())) {
            this.modifiedFeatureFillingConf.setListenFeature(structuralFeature);
        }
        this.listenFeatureText.setImage(this.labelProvider.getImage((Object)this.modifiedFeatureFillingConf.getListenFeature()));
        this.listenFeatureText.setText(this.labelProvider.getText((Object)this.modifiedFeatureFillingConf.getListenFeature()));
        this.deleteValuesButton.setEnabled(structuralFeature != null);
    }

    public EStructuralFeatureValueFillingConfiguration getModifiedFeatureFillingConfiguration() {
        return this.modifiedFeatureFillingConf;
    }
}

