/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.emf.ui.internal.exported.util.wizard.page;

import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.emf.facet.util.core.DebugUtils;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.exported.util.widget.component.metaclass.MetamodelSelectionControl;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.exported.util.wizard.page.exception.SelectedEPackageRuntimeException;
import org.eclipse.papyrus.emf.facet.util.emf.ui.internal.exported.wizard.page.ISelectEPackageWizardPage;
import org.eclipse.papyrus.emf.facet.util.emf.ui.util.EditingUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectEPackageWizardPage
extends WizardPage
implements ISelectEPackageWizardPage {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private MetamodelSelectionControl mmSelectionCtl;

    public SelectEPackageWizardPage() {
        super("Whatever");
        this.setTitle(Messages.Select_EPackage);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mmSelectionCtl.getFilterText().setFocus();
            this.setPageComplete(true);
        }
    }

    public void createControl(Composite parent) {
        this.mmSelectionCtl = new MetamodelSelectionControl(parent);
        this.mmSelectionCtl.setLayoutData(new GridData(1808));
        final FilteredList filteredList = this.mmSelectionCtl.getFilteredList();
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.item != null) {
                    SelectEPackageWizardPage.this.setPageComplete(filteredList.getSelection().length == 1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (SelectEPackageWizardPage.this.getWizard().canFinish()) {
                    SelectEPackageWizardPage.this.getWizard().performFinish();
                }
                if (SelectEPackageWizardPage.this.getNextPage() != null) {
                    SelectEPackageWizardPage.this.goToNextPage();
                }
            }
        });
        filteredList.setSelection(new int[0]);
        this.setPageComplete(false);
        this.setControl((Control)this.mmSelectionCtl);
    }

    protected void goToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    @Override
    public EPackage getSelectedEPackage() {
        Object result;
        EPackage ePackage = null;
        if (this.mmSelectionCtl.getSelectedElements() != null && EPackage.Registry.INSTANCE.containsKey((Object)(result = this.mmSelectionCtl.getSelectedElements()[0]).toString())) {
            ePackage = EPackage.Registry.INSTANCE.getEPackage(result.toString());
        }
        return ePackage;
    }

    public void loadSelectedMetamodel() {
        Object[] results = this.mmSelectionCtl.getSelectedElements();
        if (results != null) {
            ResourceSet resourceSet = EditingUtil.getEditingDomain().getResourceSet();
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                URI uri = URI.createURI((String)result.toString());
                Resource resource = resourceSet.getResource(uri, true);
                if (!resourceSet.getResources().contains((Object)resource)) {
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    packageRegistry.putAll((Map)SelectEPackageWizardPage.putResourceContents(resource, packageRegistry));
                    resourceSet.getResources().add((Object)resource);
                }
                ++n2;
            }
        }
    }

    private static EPackage.Registry putResourceContents(Resource resource, EPackage.Registry packageRegistry) {
        EPackage.Registry result = packageRegistry;
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            result.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        return result;
    }

    @Override
    public void selectPackage(String packageName) {
        DebugUtils.debug((boolean)DEBUG);
        boolean doItNow = true;
        Job[] jobArray = Job.getJobManager().find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getClass().getName().startsWith(FilteredList.class.getName())) {
                this.asyncSelectionPackage(packageName);
                DebugUtils.debug((boolean)DEBUG, (String)"Selection defered.");
                doItNow = false;
                break;
            }
            ++n2;
        }
        if (doItNow) {
            this.internalSelectPackage(packageName);
        }
    }

    private void asyncSelectionPackage(final String packageName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectEPackageWizardPage.this.selectPackage(packageName);
            }
        });
    }

    private void internalSelectPackage(String packageName) {
        FilteredList filteredList = this.mmSelectionCtl.getFilteredList();
        filteredList.setSelection((Object[])new String[]{packageName});
        if (this.getSelectedEPackage() == null) {
            throw new SelectedEPackageRuntimeException();
        }
        DebugUtils.debug((boolean)DEBUG, (String)"Selection setting finished.");
        DebugUtils.debug((boolean)DEBUG, (String)("selectedEPackage=" + this.getSelectedEPackage()));
    }
}

