/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.AbstractTimelineLayoutPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.GeneralOrderingUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.RequestUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeElementUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineTimelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullStateInvariantEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullStateInvariantVerticalLineEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.StateDefinitionEditPart;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomTimelineCompartmentLayoutEditPolicy
extends AbstractTimelineLayoutPolicy {
    private static final String ALL_MOVED_EDITPARTS = "ALL_MOVED_EDITPARTS";
    private static final int LAYOUT_FEEDBACK_HEIGHT = 4;
    private final List<IFigure> layoutFeedbackFigures = new ArrayList<IFigure>();

    protected Command getMoveChildrenCommand(Request request) {
        if (RequestUtils.isChangeBoundsRequestFor(request, UMLPackage.eINSTANCE.getStateInvariant())) {
            return this.getMoveStateInvariantCommand(request);
        }
        if (RequestUtils.isChangeBoundsRequestFor(request, FullStateInvariantVerticalLineEditPart.class)) {
            return this.getMoveVerticalLinesCommand(request);
        }
        if (RequestUtils.isChangeBoundsRequestFor(request, UMLPackage.eINSTANCE.getOccurrenceSpecification())) {
            return this.getMoveOccurrenceSpecificationsCommand(request);
        }
        return super.getMoveChildrenCommand(request);
    }

    private Command getMoveStateInvariantCommand(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        Point location = changeBoundsRequest.getLocation();
        if (location == null) {
            Activator.log.warn("Ignoring ChangeBoundsRequest without a Location");
            return UnexecutableCommand.INSTANCE;
        }
        int ordinate = location.y;
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomTimelineCompartmentLayoutEditPolicy_MoveStateInvariant);
        final FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)this.getHost().getParent();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        StateDefinitionEditPart stateDefinitionEditPart = StateDefinitionUtils.findStateDefinitionClosestToOrdinate(lifelineEditPart, ordinate);
        if (stateDefinitionEditPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        View stateDefinitionView = (View)stateDefinitionEditPart.getModel();
        final String closestStateDefinitionName = StateDefinitionUtils.getStateDefinitionName(stateDefinitionView);
        final String closestStateDefinitionId = StateDefinitionUtils.getStateDefinitionViewID(stateDefinitionView);
        List editParts = changeBoundsRequest.getEditParts();
        for (EditPart editPart : editParts) {
            if (!(editPart instanceof FullStateInvariantEditPartCN)) continue;
            FullStateInvariantEditPartCN fullStateInvariantEditPart = (FullStateInvariantEditPartCN)editPart;
            final StateInvariant stateInvariant = (StateInvariant)((View)fullStateInvariantEditPart.getModel()).getElement();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)stateInvariant);
            if (editingDomain == null) {
                throw new IllegalStateException("no editing domain");
            }
            AbstractTransactionalCommand updateStateInvariantCommand = new AbstractTransactionalCommand(editingDomain, Messages.CustomTimelineCompartmentLayoutEditPolicy_UpdateStateInvariant, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    StateInvariantUtils.setStateInvariantId(stateInvariant, closestStateDefinitionId);
                    StateInvariantUtils.setInnerStateInvariantName(stateInvariant, closestStateDefinitionName);
                    View lifelineView = (View)lifelineEditPart.getModel();
                    Lifeline lifeline = (Lifeline)lifelineView.getElement();
                    LifelineUtils.updateFragmentNames(lifeline, lifelineView);
                    return CommandResult.newOKCommandResult();
                }
            };
            compoundCommand.add((Command)new ICommandProxy((ICommand)updateStateInvariantCommand));
        }
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
        return compoundCommand;
    }

    private Command getMoveVerticalLinesCommand(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomTimelineCompartmentLayoutEditPolicy_MoveVerticalLine);
        FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)this.getHost().getParent();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        FullLifelineTimelineCompartmentEditPartCN timelineCompartmentEditPart = (FullLifelineTimelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, "Lifeline_FullSubfragmentCompartment");
        View timelineCompartmentView = (View)timelineCompartmentEditPart.getModel();
        List editParts = changeBoundsRequest.getEditParts();
        Point moveDelta = FigureUtils.scaleByZoom((Point)changeBoundsRequest.getMoveDelta(), (IFigure)lifelineEditPart.getFigure());
        moveDelta.y = 0;
        ArrayList<Node> nodesToMove = new ArrayList<Node>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List<Node> allMovedNodes = CustomTimelineCompartmentLayoutEditPolicy.getAllMovedNodes(request);
        for (EditPart editPart : editParts) {
            if (!(editPart instanceof FullStateInvariantVerticalLineEditPart)) continue;
            FullStateInvariantVerticalLineEditPart verticalLineEditPart = (FullStateInvariantVerticalLineEditPart)editPart;
            View verticalLineView = (View)verticalLineEditPart.getModel();
            int index = timelineCompartmentView.getChildren().indexOf((Object)verticalLineView);
            if (index <= 0) continue;
            int occurrenceSpecificationIndex = index - 1;
            View previousView = (View)timelineCompartmentView.getChildren().get(occurrenceSpecificationIndex);
            if (!(previousView.getElement() instanceof OccurrenceSpecification)) continue;
            Node occurrenceSpecificationNode = (Node)previousView;
            nodesToMove.add(occurrenceSpecificationNode);
            indexes.add(occurrenceSpecificationIndex);
        }
        int i = 0;
        for (Node node : nodesToMove) {
            compoundCommand.add(CustomTimelineCompartmentLayoutEditPolicy.getMoveOccurrenceSpecificationCommand(node, moveDelta, timelineCompartmentView, (Integer)indexes.get(i), allMovedNodes));
            ++i;
        }
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
        return compoundCommand;
    }

    private Command getMoveOccurrenceSpecificationsCommand(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomTimelineCompartmentLayoutEditPolicy_MoveOccurrenceSpecification);
        FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)this.getHost().getParent();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)lifelineEditPart));
        FullLifelineTimelineCompartmentEditPartCN timelineCompartmentEditPart = (FullLifelineTimelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId((EditPart)lifelineEditPart, "Lifeline_FullSubfragmentCompartment");
        View timelineCompartmentView = (View)timelineCompartmentEditPart.getModel();
        List editParts = changeBoundsRequest.getEditParts();
        Point moveDelta = FigureUtils.scaleByZoom((Point)changeBoundsRequest.getMoveDelta(), (IFigure)lifelineEditPart.getFigure());
        moveDelta.y = 0;
        ArrayList<Node> nodesToMove = new ArrayList<Node>();
        List<Node> allMovedNodes = CustomTimelineCompartmentLayoutEditPolicy.getAllMovedNodes(request);
        for (EditPart editPart : editParts) {
            if (!OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(editPart)) continue;
            Node occurrenceSpecificationNode = (Node)editPart.getModel();
            Rectangle figureBounds = ((GraphicalEditPart)editPart).getFigure().getBounds();
            moveDelta.x = Math.min(moveDelta.x, this.getHostFigure().getBounds().width - figureBounds.x - figureBounds.width - 2);
            nodesToMove.add(occurrenceSpecificationNode);
        }
        for (Node node : nodesToMove) {
            int index = timelineCompartmentView.getChildren().indexOf((Object)node);
            if (index < 0) continue;
            compoundCommand.add(CustomTimelineCompartmentLayoutEditPolicy.getMoveOccurrenceSpecificationCommand(node, moveDelta, timelineCompartmentView, index, allMovedNodes));
        }
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)lifelineEditPart));
        return compoundCommand;
    }

    private static List<Node> getAllMovedNodes(Request request) {
        ArrayList<Node> allMovedNodes = new ArrayList<Node>();
        Map extendedData = request.getExtendedData();
        if (extendedData != null) {
            List editParts = (List)extendedData.get(ALL_MOVED_EDITPARTS);
            if (editParts == null && request instanceof GroupRequest) {
                GroupRequest groupRequest = (GroupRequest)request;
                editParts = groupRequest.getEditParts();
            }
            if (editParts != null) {
                for (EditPart editPart : editParts) {
                    GraphicalEditPart graphicalEditPart;
                    Object model;
                    if (!(editPart instanceof GraphicalEditPart) || !((model = (graphicalEditPart = (GraphicalEditPart)editPart).getModel()) instanceof Node)) continue;
                    Node node = (Node)model;
                    allMovedNodes.add(node);
                }
            }
        }
        return allMovedNodes;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        View childView = (View)child.getModel();
        String visualID = UMLVisualIDRegistry.getVisualID(childView);
        if ("StateInvariant_FullShape".equals(visualID) || OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(visualID) || "Node_StateInvariantTransitionShape".equals(visualID) || TimeElementUtils.isTimeElementEditPart(visualID) || GeneralOrderingUtils.isGeneralOrderingEditPart(visualID)) {
            return this.createNonResizableEditPolicy();
        }
        return super.createChildEditPolicy(child);
    }

    private NonResizableEditPolicy createNonResizableEditPolicy() {
        return new NonResizableEditPolicyEx(){

            protected Command getMoveCommand(ChangeBoundsRequest request) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
                req.setEditParts(this.getHost());
                Map extendedData = request.getExtendedData();
                extendedData.put(CustomTimelineCompartmentLayoutEditPolicy.ALL_MOVED_EDITPARTS, request.getEditParts());
                req.setMoveDelta(request.getMoveDelta());
                req.setSizeDelta(request.getSizeDelta());
                req.setLocation(request.getLocation());
                req.setExtendedData(extendedData);
                return this.getHost().getParent().getCommand((Request)req);
            }
        };
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!RequestUtils.isChangeBoundsRequestFor(request, UMLPackage.eINSTANCE.getStateInvariant())) {
            return;
        }
        this.eraseLayoutTargetFeedback();
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        int targetY = this.computeTargetOrdinate(changeBoundsRequest);
        List editParts = changeBoundsRequest.getEditParts();
        double scale = FigureUtils.getScale((IFigure)this.getHostFigure());
        for (GraphicalEditPart editPart : editParts) {
            Rectangle figureBounds = editPart.getFigure().getBounds();
            Rectangle containerBounds = ((GraphicalEditPart)this.getHost()).getFigure().getBounds();
            Rectangle feedbackBounds = new Rectangle(containerBounds.x + figureBounds.x, targetY - 2, figureBounds.width, 4);
            feedbackBounds.scale(scale);
            this.layoutFeedbackFigures.add(this.createLayoutTargetFeedbackFigure(feedbackBounds));
        }
    }

    private int computeTargetOrdinate(ChangeBoundsRequest request) {
        int ordinate = request.getLocation().y;
        FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)this.getHost().getParent();
        StateDefinitionEditPart stateDefinitionEditPart = StateDefinitionUtils.findStateDefinitionClosestToOrdinate(lifelineEditPart, ordinate);
        Rectangle figureBounds = stateDefinitionEditPart.getFigure().getBounds();
        return figureBounds.y + figureBounds.height / 2;
    }

    protected IFigure createLayoutTargetFeedbackFigure(Rectangle bounds) {
        RectangleFigure r = new RectangleFigure();
        r.setForegroundColor(ColorConstants.darkBlue);
        r.setBackgroundColor(ColorConstants.lightBlue);
        r.setBounds(bounds);
        r.validate();
        this.addFeedback((IFigure)r);
        return r;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (!RequestUtils.isChangeBoundsRequestFor(request, UMLPackage.eINSTANCE.getStateInvariant())) {
            return;
        }
        this.eraseLayoutTargetFeedback();
    }

    private void eraseLayoutTargetFeedback() {
        for (IFigure figure : this.layoutFeedbackFigures) {
            this.removeFeedback(figure);
        }
        this.layoutFeedbackFigures.clear();
    }
}

