/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.resource.DependencyManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.markerlistener.dialogs.DiagnosticDialog;
import org.eclipse.papyrus.infra.ui.util.TransactionUIHelper;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.modelrepair.ui.BrowseProfilesBlock;
import org.eclipse.papyrus.uml.tools.util.ProfileHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Profile;

public class SwitchProfileDialog
extends SelectionDialog {
    private static final int APPLY_ID = 1025;
    private static final String APPLY_LABEL = "Apply";
    private ModelSet modelSet;
    private TransactionalEditingDomain editingDomain;
    protected TableViewer viewer;
    protected Table table;
    protected BrowseProfilesBlock browseBlock;
    protected LabelProviderService labelProviderService;
    protected final Map<Resource, Resource> profilesToEdit = new HashMap<Resource, Resource>();

    public SwitchProfileDialog(Shell shell, ModelSet modelSet, TransactionalEditingDomain domain) throws ServiceException {
        super(shell);
        this.modelSet = modelSet;
        this.editingDomain = domain;
        this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)modelSet);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 64);
        String description = "Select an applied profile, then select a profile (either from the workspace, or a registered one).\n";
        description = String.valueOf(description) + "If the profiles are equivalent, the selected profile will replace the applied profile. Stereotype applications will be kept.\n";
        description = String.valueOf(description) + "Two profiles are equivalent if one is the copy of the other or if you have deployed a workspace profile in a plug-in.\n";
        description = String.valueOf(description) + "If a profile P' is a copy of a profile P, with some modifications, they are also equivalent.";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label warningLabel = new Label(self, 64);
        String warning = "Replacing an applied profile with a totally different one will result in loss of stereotype applications.";
        warningLabel.setText(warning);
        warningLabel.setForeground(parent.getDisplay().getSystemColor(4));
        warningLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        EventBus bus = new EventBus("profileSelection");
        this.browseBlock = new BrowseProfilesBlock(bus, this.labelProviderService);
        this.browseBlock.createControl(self, 0).setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        bus.register(new Object(){

            @Subscribe
            public void workspaceProfileSelected(IFile file) {
                IPath filePath = file.getFullPath();
                URI workspaceURI = URI.createPlatformResourceURI((String)filePath.toPortableString(), (boolean)true);
                SwitchProfileDialog.this.replaceSelectionWith(workspaceURI);
            }

            @Subscribe
            public void registeredProfileSelected(IRegisteredProfile profile) {
                SwitchProfileDialog.this.replaceSelectionWith(profile.getUri());
            }
        });
        this.viewer = new TableViewer(self, 67584);
        this.table = this.viewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText("Applied Profile");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 150, true));
        TableColumn locationColumn = new TableColumn(this.table, 0);
        locationColumn.setText("Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        TableColumn newLocationColumn = new TableColumn(this.table, 0);
        newLocationColumn.setText("New Location");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 500, true));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ModelSet) {
                    ModelSet modelSet = (ModelSet)inputElement;
                    Collection allAppliedProfiles = ProfileHelper.getAllAppliedProfiles((ModelSet)modelSet);
                    HashSet<Resource> allResources = new HashSet<Resource>();
                    for (Profile appliedProfile : allAppliedProfiles) {
                        URI profileResourceURI = EcoreUtil.getURI((EObject)appliedProfile).trimFragment();
                        Resource resource = modelSet.getResource(profileResourceURI, true);
                        allResources.add(resource);
                    }
                    return allResources.toArray();
                }
                return null;
            }
        });
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    for (EObject rootElement : resource.getContents()) {
                        if (!(rootElement instanceof Profile)) continue;
                        return ((Profile)rootElement).getName();
                    }
                    return resource.getURI().toString();
                }
                return super.getText(element);
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProfileColumnsLabelProvider((ILabelProvider)labelProvider));
        this.viewer.setComparator(new ViewerComparator((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                return Strings.nullToEmpty((String)this.val$labelProvider.getText(e1)).compareTo(Strings.nullToEmpty((String)this.val$labelProvider.getText(e2)));
            }
        });
        this.viewer.setInput((Object)this.modelSet);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SwitchProfileDialog.this.updateControls();
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener((ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$labelProvider.dispose();
            }
        });
        return contents;
    }

    protected void updateControls() {
        String newTitle = "Switch Profile Locations";
        if (!this.profilesToEdit.isEmpty()) {
            newTitle = String.valueOf(newTitle) + " *";
        }
        this.getShell().setText(newTitle);
        this.getButton(1025).setEnabled(!this.profilesToEdit.isEmpty());
        boolean enableBrowse = !this.viewer.getSelection().isEmpty();
        this.browseBlock.setEnabled(enableBrowse);
        this.viewer.refresh();
    }

    protected void applyPressed() {
        if (this.profilesToEdit.isEmpty()) {
            return;
        }
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain, "Edit profile applications"){

            protected void doExecute() {
                final LinkedList allReplacements = new LinkedList();
                final BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.papyrus.uml.modelrepair", 0, "Problems in switching profile", null);
                IRunnableWithProgress runnable = TransactionUIHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)SwitchProfileDialog.this.editingDomain, (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this).SwitchProfileDialog.this.profilesToEdit.size());
                        for (Map.Entry<Resource, Resource> replacementEntry : (this).SwitchProfileDialog.this.profilesToEdit.entrySet()) {
                            URI targetURI;
                            URI uriToReplace = replacementEntry.getKey().getURI();
                            if (uriToReplace.equals(targetURI = replacementEntry.getValue().getURI())) continue;
                            Collection result = new DependencyManager((ResourceSet)SwitchProfileDialog.this.modelSet).updateDependencies(uriToReplace, targetURI, (DiagnosticChain)diagnostics, (IProgressMonitor)subMonitor.newChild(1));
                            allReplacements.addAll(result);
                        }
                        subMonitor.done();
                    }
                });
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to execute profile switch."), 2);
                }
                if (allReplacements.isEmpty()) {
                    MessageDialog.openWarning((Shell)SwitchProfileDialog.this.getShell(), (String)"Switch Profiles", (String)"No profile applications were found to update.");
                } else if (diagnostics.getSeverity() > 0) {
                    DiagnosticDialog dialog = new DiagnosticDialog(SwitchProfileDialog.this.getShell(), "Problems in Switching Profiles", "Some incompatible differences in the target profile likely resulted in loss or transformation of data in stereotype applications. Please review the specific details and take any corrective action that may be required.", (Diagnostic)diagnostics, 6);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            }
        });
        this.profilesToEdit.clear();
        this.updateControls();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, APPLY_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                if (this.profilesToEdit.isEmpty() || MessageDialog.openQuestion((Shell)this.getShell(), (String)"Switch Profiles", (String)"You have not yet applied the pending profile switch(es). Are you sure you want to cancel?")) break;
                return;
            }
            case 1025: {
                this.applyPressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.updateControls();
        this.getShell().setText("Switch Profile Locations");
        this.getShell().setMinimumSize(600, 400);
        this.getShell().pack();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public boolean close() {
        this.profilesToEdit.clear();
        return super.close();
    }

    protected Resource getSelectedResource() {
        Object selectedElement;
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Resource) {
            return (Resource)selectedElement;
        }
        return null;
    }

    protected void replaceSelectionWith(URI targetURI) {
        Resource targetResource = this.modelSet.getResource(targetURI, true);
        if (this.getSelectedResource() != targetResource) {
            this.profilesToEdit.put(this.getSelectedResource(), targetResource);
            this.updateControls();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Nothing changed", (String)"Nothing to change");
        }
    }

    private class ProfileColumnsLabelProvider
    extends ColumnLabelProvider {
        private ILabelProvider defaultLabelProvider;

        public ProfileColumnsLabelProvider(ILabelProvider defaultLabelProvider) {
            this.defaultLabelProvider = defaultLabelProvider;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            Resource resource = element instanceof Resource ? (Resource)element : null;
            switch (cell.getColumnIndex()) {
                case 0: {
                    this.updateName(cell);
                    break;
                }
                case 1: {
                    this.updateLocation(cell, resource);
                    break;
                }
                case 2: {
                    this.updateNewLocation(cell, resource);
                }
            }
        }

        public void updateName(ViewerCell cell) {
            cell.setImage(this.defaultLabelProvider.getImage(cell.getElement()));
            cell.setText(this.defaultLabelProvider.getText(cell.getElement()));
        }

        public void updateLocation(ViewerCell cell, Resource resource) {
            URI uri;
            String location = "Unknown";
            if (resource != null && (uri = resource.getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }

        public void updateNewLocation(ViewerCell cell, Resource resource) {
            URI uri;
            String location = "";
            if ((resource = SwitchProfileDialog.this.profilesToEdit.get(resource)) != null && (uri = resource.getURI()) != null) {
                location = uri.toString();
            }
            cell.setText(location);
        }
    }
}

