/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.commandstack.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.emf.facet.common.ui.internal.views.AbstractTreeView;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.CommandUtils;
import org.eclipse.swt.widgets.Composite;

public class CommandStackView
extends AbstractTreeView {
    private final int maxSize = 25;
    private final IOperationHistory history;
    private final List<IUndoableOperation> commandList = new ArrayList<IUndoableOperation>();
    private final Map<IUndoableOperation, String> dates = new HashMap<IUndoableOperation, String>();
    private final IOperationHistoryListener historyListener;
    private Object[] result;

    public CommandStackView() {
        this.history = OperationHistoryFactory.getOperationHistory();
        this.historyListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (!CommandStackView.this.commandList.contains(event.getOperation())) {
                    if (CommandStackView.this.commandList.size() == 25) {
                        IUndoableOperation removedOperation = (IUndoableOperation)CommandStackView.this.commandList.remove(25 - 1);
                        CommandStackView.this.dates.remove(removedOperation);
                    }
                    CommandStackView.this.commandList.add(0, event.getOperation());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                    Calendar cal = Calendar.getInstance();
                    CommandStackView.this.dates.put(event.getOperation(), dateFormat.format(cal.getTime()));
                    CommandStackView.this.refresh(true);
                }
            }
        };
        this.history.addOperationHistoryListener(this.historyListener);
    }

    private boolean isValidUndoContext(IUndoableOperation operation) {
        IUndoContext[] iUndoContextArray = operation.getContexts();
        int n = iUndoContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext undoContext = iUndoContextArray[n2];
            if (undoContext instanceof EditingDomainUndoContext) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void createColumns() {
        this.createNameColumn();
        this.createDescriptionColumn();
        this.createCommandTypeColumn();
        this.createTimeColumn();
        this.createUndoContextColumn();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)new Action(){

            public void run() {
                CommandStackView.this.clear();
                CommandStackView.this.refresh(true);
            }

            public boolean isEnabled() {
                return true;
            }

            public String getToolTipText() {
                return this.getText();
            }

            public String getText() {
                return "Clear the view";
            }
        });
    }

    private void createCommandTypeColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return element.getClass().getName();
            }
        };
        this.createColumn("Type", "TYPE_COLUMN_ID", 200, columnLabelProvider);
    }

    protected void createNameColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return CommandUtils.getLabel((Object)element);
            }
        };
        this.createColumn("Name", "NAME_COLUMN_ID", 200, columnLabelProvider);
    }

    protected void createUndoContextColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IUndoableOperation) {
                    return Boolean.toString(CommandStackView.this.isValidUndoContext((IUndoableOperation)element));
                }
                return "?";
            }
        };
        this.createColumn("EMF Command Stack", "UNDO_CONTEXT_COLUMN_ID", 100, columnLabelProvider);
    }

    protected void createDescriptionColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractCommand) {
                    return ((AbstractCommand)element).getDescription();
                }
                return "no description";
            }
        };
        this.createColumn("Description", "DESCRIPTION_COLUMN_ID", 150, columnLabelProvider);
    }

    protected void createTimeColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (CommandStackView.this.dates.containsKey(element)) {
                    return (String)CommandStackView.this.dates.get(element);
                }
                return "";
            }
        };
        this.createColumn("Time", "TIME_COLUMN_ID", 100, columnLabelProvider);
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Command) {
                    return new Object[]{inputElement};
                }
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CompoundCommand) {
                    return ((CompoundCommand)parentElement).getCommandList().toArray();
                }
                if (parentElement instanceof CompositeCommand) {
                    ArrayList children = new ArrayList();
                    ListIterator iter = ((CompositeCommand)parentElement).listIterator();
                    while (iter.hasNext()) {
                        children.add(iter.next());
                    }
                    return children.toArray();
                }
                if (parentElement instanceof EMFCommandOperation) {
                    ArrayList<Command> children = new ArrayList<Command>();
                    children.add(((EMFCommandOperation)parentElement).getCommand());
                    return children.toArray();
                }
                if (parentElement instanceof ICommandWrapper) {
                    return new Object[]{((ICommandWrapper)parentElement).getWrappedCommand()};
                }
                if (CommandUtils.isCompound((Object)parentElement)) {
                    ArrayList children = new ArrayList();
                    for (Object next : CommandUtils.getChildren((Object)parentElement)) {
                        children.add(next);
                    }
                    return children.toArray();
                }
                if (ICommandWrapper.isWrapper((Object)parentElement, Object.class)) {
                    return new Object[]{ICommandWrapper.unwrap((Object)parentElement, Object.class)};
                }
                return new Object[0];
            }
        };
    }

    protected void openElement(Object element) {
    }

    protected String getRefreshMessage() {
        return "Refresh CommandStack View";
    }

    protected Object getInput() {
        return this.commandList;
    }

    public void dispose() {
        super.dispose();
        this.history.removeOperationHistoryListener(this.historyListener);
        this.clear();
    }

    private void clear() {
        this.commandList.clear();
        this.dates.clear();
    }
}

