/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class SynchronousExecutorService
extends AbstractExecutorService {
    public static final Runnable FLUSH = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            long now = System.currentTimeMillis();
            long deadline = now + unit.toMillis(timeout);
            while (!this.isTerminated()) {
                if (this.done.await(deadline - now, TimeUnit.MILLISECONDS)) {
                } else {
                    now = System.currentTimeMillis();
                    if (now < deadline) continue;
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.queue.isEmpty();
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.queue.clear();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ImmutableList result;
        this.lock.lock();
        try {
            if (this.isShutdown.compareAndSet(false, true)) {
                result = ImmutableList.copyOf(this.queue);
                this.queue.clear();
                this.done.signalAll();
            } else {
                result = Collections.emptyList();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public void execute(Runnable command) {
        boolean flush = this.isFlush(command);
        this.lock.lock();
        try {
            if (this.isShutdown()) {
                throw new RejectedExecutionException("executor is shut down");
            }
            this.queue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        if (flush) {
            this.flush();
        }
    }

    public void flush() {
        this.lock.lock();
        try {
            Runnable next = this.queue.poll();
            while (next != null) {
                block10: {
                    this.lock.unlock();
                    try {
                        try {
                            next.run();
                        }
                        catch (Exception e) {
                            String bsn = "org.eclipse.papyrus.junit.utils";
                            Status status = new Status(4, "org.eclipse.papyrus.junit.utils", "Uncaught exception in async runnable.", (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.papyrus.junit.utils")).log((IStatus)status);
                            this.lock.lock();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.lock.lock();
                        throw throwable;
                    }
                    this.lock.lock();
                }
                next = this.queue.poll();
            }
            if (this.isShutdown()) {
                this.done.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable task, T value) {
        return new MyFutureTask<T>(task, value);
    }

    boolean isFlush(Runnable task) {
        return task == FLUSH || task instanceof MyFutureTask && ((MyFutureTask)task).task == FLUSH;
    }

    private static class MyFutureTask<V>
    extends FutureTask<V> {
        final Runnable task;

        MyFutureTask(Runnable task, V value) {
            super(task, value);
            this.task = task;
        }
    }
}

