/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.papyrus.toolsmiths.validation.architecture.Activator;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureBuildChecker;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureExternalDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers.ArchitectureFileChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.PluginValidationService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArchitecturePluginChecker {
    public static void checkArchitecturePlugin(IProject project) {
        Shell shell = Display.getCurrent().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                Collection architectureFiles = ProjectManagementService.getFilesFromProject((IContainer)project, (String)"architecture", (boolean)true);
                monitor.beginTask("Validate Architecture plug-in", 1 + architectureFiles.size() * 3);
                monitor.subTask("Prepare plug-in validation");
                MarkersService.deleteMarkers((IResource)project, (String)"org.eclipse.papyrus.toolsmiths.validation.architecture.diagnostic");
                PluginValidationService pluginValidationService = new PluginValidationService();
                pluginValidationService.addPluginChecker((IPluginChecker)new ArchitectureDependenciesChecker(project));
                for (IFile architectureFile : architectureFiles) {
                    URI architectureFileURI = URI.createPlatformResourceURI((String)architectureFile.getFullPath().toOSString(), (boolean)true);
                    Resource resource = new ResourceSetImpl().getResource(architectureFileURI, true);
                    pluginValidationService.addPluginChecker((IPluginChecker)new ArchitectureFileChecker(architectureFile, resource));
                    pluginValidationService.addPluginChecker((IPluginChecker)new ArchitectureExtensionsChecker(project, architectureFile));
                    pluginValidationService.addPluginChecker((IPluginChecker)new ArchitectureExternalDependenciesChecker(project, architectureFile, resource));
                    pluginValidationService.addPluginChecker((IPluginChecker)new ArchitectureBuildChecker(project, architectureFile));
                }
                monitor.worked(1);
                pluginValidationService.validate(monitor);
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

