/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;

public class ProfileBuildChecker
implements IPluginChecker {
    private final IProject project;
    private final IFile profileFile;

    public ProfileBuildChecker(IProject project, IFile profileFile) {
        this.project = project;
        this.profileFile = profileFile;
    }

    public void check(IProgressMonitor monitor) {
        IBuildModel buildModel;
        if (monitor != null) {
            monitor.subTask("Validate 'build.properties' file for profile '" + this.profileFile.getName() + "'.");
        }
        if ((buildModel = ProjectManagementService.getPluginBuild((IProject)this.project)) != null) {
            boolean containsProfile = false;
            String profilePath = this.profileFile.getProjectRelativePath().toString();
            IBuild build = buildModel.getBuild();
            IBuildEntry buildEntry = build.getEntry("bin.includes");
            String[] tokens = buildEntry.getTokens();
            int i = 0;
            while (i < tokens.length && !containsProfile) {
                containsProfile = profilePath.startsWith(tokens[i]);
                ++i;
            }
            if (!containsProfile) {
                IFile buildPropertiesFile = ProjectManagementService.getBuildFile((IContainer)this.project);
                MarkersService.createMarker((IResource)buildPropertiesFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("The build does not contains entry for file '" + profilePath + "'"), (int)2);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

