/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.core.internal.clipboard.CopierFactory;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.CopyPasteUtil;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class DefaultDiagramPasteCommand
extends AbstractTransactionalCommand {
    protected View container = null;
    protected List<EObject> semanticList = new ArrayList<EObject>();
    protected List<EObject> viewList = new ArrayList<EObject>();
    protected ICommand editCommand;
    private CompoundCommand allDropCommand;
    private GraphicalEditPart targetEditPart;
    private List<EObject> objectToDrop;
    private List<EObject> elementsToMove;

    public DefaultDiagramPasteCommand(TransactionalEditingDomain editingDomain, String label, PapyrusClipboard<Object> papyrusClipboard, GraphicalEditPart targetEditPart) {
        super(editingDomain, label, null);
        this.container = (View)targetEditPart.getModel();
        this.targetEditPart = targetEditPart;
        EcoreUtil.Copier copier = new CopierFactory(editingDomain.getResourceSet()).get();
        List rootElementInClipboard = EcoreUtil.filterDescendants(CopyPasteUtil.filterEObject(papyrusClipboard));
        copier.copyAll((Collection)rootElementInClipboard);
        copier.copyReferences();
        this.viewList.addAll(EcoreUtil.filterDescendants((Collection)copier.values()));
        for (Object eObject : rootElementInClipboard) {
            if (eObject instanceof View) continue;
            this.viewList.remove(copier.get(eObject));
            this.semanticList.add((EObject)copier.get(eObject));
        }
        Map<Object, EObject> transtypeCopier = CopyPasteUtil.transtypeCopier(copier);
        papyrusClipboard.addAllInternalToTargetCopy(transtypeCopier);
        List semanticRootList = EcoreUtil.filterDescendants(this.semanticList);
        MoveRequest moveRequest = new MoveRequest(this.container.getElement(), semanticRootList);
        this.elementsToMove = semanticRootList;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.container.getElement());
        if (provider != null) {
            this.editCommand = provider.getEditCommand((IEditCommandRequest)moveRequest);
        }
        if (!papyrusClipboard.getContainerType().equals(targetEditPart.getNotationView().getDiagram().getType()) || this.viewList.isEmpty()) {
            this.objectToDrop = semanticRootList;
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.editCommand.execute(progressMonitor, info);
        if (this.objectToDrop != null) {
            this.constructDropRequest(this.targetEditPart, this.objectToDrop);
        } else if (this.viewList != null && !this.viewList.isEmpty()) {
            this.constructViewDropRequest(this.targetEditPart, this.viewList);
        }
        if (this.allDropCommand != null && !this.allDropCommand.isEmpty()) {
            this.allDropCommand.execute();
        }
        if (this.elementsToMove != null && !this.elementsToMove.isEmpty()) {
            for (EObject eObject : this.elementsToMove) {
                IElementEditService provider;
                DestroyElementRequest destroyRequest = new DestroyElementRequest(eObject, false);
                if (eObject.eContainer() == null || (provider = ElementEditServiceUtils.getCommandProvider((EObject)eObject.eContainer())) == null) continue;
                ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                destroyCommand.execute(progressMonitor, info);
            }
        }
        return this.editCommand.getCommandResult();
    }

    protected void constructDropRequest(GraphicalEditPart targetEditPart, List<EObject> objectToDrop) {
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        if (this.container instanceof Diagram) {
            Point cursorPosition = CopyPasteUtil.getCursorPosition(targetEditPart);
            this.allDropCommand = new CompoundCommand("Drop all semantics elements on diagram");
            for (EObject eObject : objectToDrop) {
                dropObjectsRequest.setObjects(Collections.singletonList(eObject));
                dropObjectsRequest.setLocation(cursorPosition);
                Command command = targetEditPart.getCommand((Request)dropObjectsRequest);
                this.allDropCommand.add(command);
                cursorPosition = CopyPasteUtil.shiftLayout(cursorPosition);
            }
        } else if (!(this.container instanceof Diagram)) {
            Rectangle bounds = targetEditPart.getFigure().getBounds();
            Point center = bounds.getCenter();
            this.allDropCommand = new CompoundCommand("Drop all semantics elements on a view");
            dropObjectsRequest.setObjects(objectToDrop);
            dropObjectsRequest.setLocation(center);
            Command command = targetEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) {
                command = CopyPasteUtil.lookForCommandInSubContainer(targetEditPart, objectToDrop);
            }
            this.allDropCommand.add(command);
        }
    }

    protected void constructViewDropRequest(GraphicalEditPart targetEditPart, List<EObject> viewsToDrop) {
        DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
        Point newlocation = CopyPasteUtil.getCursorPosition(targetEditPart);
        this.allDropCommand = new CompoundCommand("Drop all semantics elements");
        for (EObject eObject : viewsToDrop) {
            if (!(eObject instanceof View) || ((View)eObject).getElement() == null) continue;
            EObject objectToDrop = ((View)eObject).getElement();
            dropObjectsRequest.setObjects(Collections.singletonList(objectToDrop));
            dropObjectsRequest.setLocation(newlocation);
            Command command = targetEditPart.getCommand((Request)dropObjectsRequest);
            if (command == null) {
                command = CopyPasteUtil.lookForCommandInSubContainer(targetEditPart, Collections.singletonList(objectToDrop), newlocation);
            }
            if (command == null || !command.canExecute()) continue;
            if (this.elementsToMove.contains(objectToDrop)) {
                this.elementsToMove.remove(objectToDrop);
            }
            this.allDropCommand.add(command);
            newlocation = CopyPasteUtil.shiftLayout(newlocation);
        }
    }
}

