/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;

public class SelectSeveralLinksEditPartTracker
extends SelectEditPartTracker {
    private final int MODIFIER_NO_SNAPPING;
    private Request sourceRequest;
    private int index = -1;
    private String type;
    private boolean bSourceFeedback = false;
    protected HashMap<EditPart, Point> locationsForEditParts = new HashMap();
    int[] relativePosition = null;

    public SelectSeveralLinksEditPartTracker(org.eclipse.gef.ConnectionEditPart owner) {
        super((EditPart)owner);
        this.MODIFIER_NO_SNAPPING = SWT.getPlatform().equals("carbon") ? 262144 : 65536;
    }

    protected boolean handleButtonDown(int button) {
        if (!super.handleButtonDown(button)) {
            return false;
        }
        Point p = this.getLocation();
        this.getConnection().translateToRelative((Translatable)p);
        PointList points = this.getConnection().getPoints();
        Dimension size = new Dimension(7, 7);
        this.getConnection().translateToRelative((Translatable)size);
        int i = 1;
        while (i < points.size() - 1) {
            Point ptCenter = points.getPoint(i);
            Rectangle rect = new Rectangle(ptCenter.x - size.width / 2, ptCenter.y - size.height / 2, size.width, size.height);
            if (rect.contains(p)) {
                this.setType("move bendpoint");
                this.setIndex(i);
            }
            ++i;
        }
        if (this.getIndex() == -1) {
            this.setIndex(PointListUtilities.findNearestLineSegIndexOfPoint((PointList)this.getConnection().getPoints(), (Point)new Point(p.x, p.y)));
            this.setIndex(this.getIndex() - 1);
            this.setType("create bendpoint");
        }
        List editparts = this.getOperationSet();
        this.relativePosition = new int[editparts.size()];
        if (editparts.size() > 1) {
            int i2 = 0;
            while (i2 < editparts.size() - 1) {
                Object currentEditPart = editparts.get(i2);
                Object nextEditPart = editparts.get(i2 + 1);
                if (currentEditPart instanceof ConnectionEditPart && nextEditPart instanceof ConnectionEditPart) {
                    Connection currentConnection = ((ConnectionEditPart)currentEditPart).getConnectionFigure();
                    Connection nextConnection = ((ConnectionEditPart)nextEditPart).getConnectionFigure();
                    Point currentConnectionPosition = currentConnection.getPoints().getFirstPoint().getCopy();
                    Point nextConnectionPosition = nextConnection.getPoints().getFirstPoint().getCopy();
                    this.relativePosition[i2] = nextConnectionPosition.y - currentConnectionPosition.y;
                }
                ++i2;
            }
        }
        return true;
    }

    protected boolean shouldAllowDrag() {
        return this.getIndex() != -1;
    }

    protected boolean handleButtonUp(int button) {
        boolean bExecuteDrag = this.isInState(4) && this.shouldAllowDrag();
        boolean bRet = super.handleButtonUp(button);
        if (bExecuteDrag) {
            this.eraseSourceFeedback();
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        return bRet;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(4) && this.shouldAllowDrag()) {
            this.updateSourceRequest();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    protected Cursor calculateCursor() {
        if (this.getType() == "move bendpoint") {
            return Cursors.CURSOR_SEG_MOVE;
        }
        return this.getConnection().getCursor();
    }

    public void deactivate() {
        if (!this.isInState(0x40000000)) {
            this.eraseSourceFeedback();
        }
        this.sourceRequest = null;
        super.deactivate();
    }

    private boolean isShowingFeedback() {
        return this.bSourceFeedback;
    }

    private void setShowingFeedback(boolean bSet) {
        this.bSourceFeedback = bSet;
    }

    protected List createOperationSet() {
        ArrayList<org.eclipse.gef.ConnectionEditPart> list = new ArrayList<org.eclipse.gef.ConnectionEditPart>();
        list.add(this.getConnectionEditPart());
        return list;
    }

    private void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            LocationRequest locationRequest = (LocationRequest)this.getSourceRequest();
            if (this.locationsForEditParts.get(editPart) != null) {
                Point location = this.locationsForEditParts.get(editPart);
                locationRequest.setLocation(location);
                editPart.showSourceFeedback((Request)locationRequest);
            }
            ++i;
        }
        this.setShowingFeedback(true);
    }

    private void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setShowingFeedback(false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            LocationRequest locationRequest = (LocationRequest)this.getSourceRequest();
            if (this.locationsForEditParts.get(editPart) != null) {
                Point location = this.locationsForEditParts.get(editPart);
                locationRequest.setLocation(location);
                editPart.eraseSourceFeedback((Request)locationRequest);
            }
            ++i;
        }
    }

    private Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    protected Object getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected Request createSourceRequest() {
        BendpointRequest request = new BendpointRequest();
        request.setType(this.getType());
        request.setIndex(this.getIndex());
        request.setSource((org.eclipse.gef.ConnectionEditPart)this.getSourceEditPart());
        return request;
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("change bounds");
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            LocationRequest locationRequest = (LocationRequest)this.getSourceRequest();
            if (this.locationsForEditParts.get(part) != null) {
                Point location = this.locationsForEditParts.get(part);
                locationRequest.setLocation(location);
                command.add(part.getCommand((Request)locationRequest));
            }
            ++i;
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        return this.getType().toString();
    }

    private Connection getConnection() {
        return (Connection)this.getConnectionEditPart().getFigure();
    }

    private org.eclipse.gef.ConnectionEditPart getConnectionEditPart() {
        return (org.eclipse.gef.ConnectionEditPart)this.getSourceEditPart();
    }

    protected String getDebugName() {
        return "Bendpoint Handle Tracker " + this.getCommandName();
    }

    protected int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    protected void updateSourceRequest() {
        List editparts = this.getOperationSet();
        Dimension delta = this.getDragMoveDelta();
        Point mouseLocation = this.getStartLocation().getCopy();
        mouseLocation.translate(delta.width, delta.height);
        int index = 0;
        while (index < editparts.size()) {
            Object currentEditPart = editparts.get(index);
            if (currentEditPart instanceof ConnectionEditPart) {
                if (index > 0) {
                    mouseLocation.translate(new Dimension(0, this.relativePosition[index - 1]));
                }
                this.locationsForEditParts.put((EditPart)currentEditPart, mouseLocation.getCopy());
            }
            ++index;
        }
    }

    protected List getOperationSet() {
        if (this.getCurrentViewer().getSelectedEditParts().contains(this.getSourceEditPart())) {
            return this.getCurrentViewer().getSelectedEditParts();
        }
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        result.add(this.getSourceEditPart());
        return result;
    }
}

