/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.service;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import org.eclipse.papyrus.infra.sync.ISyncObject;
import org.eclipse.papyrus.infra.sync.service.ISyncService;

public abstract class SyncServiceRunnable<V, X extends Exception> {
    private final TypeToken<X> exceptionType = new TypeToken<X>(this.getClass()){};

    public abstract V run(ISyncService var1) throws X;

    public final Class<X> getExceptionType() {
        return this.exceptionType.getRawType();
    }

    public CheckedFuture<V, X> asFuture(final ISyncObject context) {
        return this.checked((ListenableFuture<V>)ListenableFutureTask.create((Callable)new Callable<V>(){

            @Override
            public V call() throws Exception {
                return context.run(SyncServiceRunnable.this);
            }
        }));
    }

    private CheckedFuture<V, X> checked(ListenableFuture<V> future) {
        class Checked
        extends AbstractCheckedFuture<V, X>
        implements Runnable {
            private final /* synthetic */ ListenableFuture val$future;

            Checked(ListenableFuture listenableFuture) {
                this.val$future = listenableFuture;
                super(listenableFuture);
            }

            @Override
            public void run() {
                ((Runnable)this.val$future).run();
            }

            protected X mapException(Exception e) {
                if (SyncServiceRunnable.this.getExceptionType().isInstance(e)) {
                    return (Exception)SyncServiceRunnable.this.getExceptionType().cast(e);
                }
                throw new UndeclaredThrowableException(e);
            }
        }
        return new Checked(future);
    }

    public static abstract class Safe<V>
    extends SyncServiceRunnable<V, RuntimeException> {
        @Override
        public abstract V run(ISyncService var1);
    }
}

