/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLPackage;

public class CallOperationActionParser
extends MessageFormatParser
implements ISemanticParser {
    private static final UMLPackage eUML = UMLPackage.eINSTANCE;

    public CallOperationActionParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public CallOperationActionParser(EAttribute[] features) {
        super(features);
    }

    public CallOperationActionParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isAffectingFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof CallOperationAction) {
            CallOperationAction action = (CallOperationAction)obj;
            String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)action);
            String operation = "";
            if (name == null) {
                name = "";
            }
            if (action.getOperation() != null && (operation = UMLLabelInternationalization.getInstance().getLabel((NamedElement)action.getOperation())) == null) {
                operation = "";
            }
            return this.getPrintString(name, operation);
        }
        return " ";
    }

    private String getPrintString(String name, String operation) {
        return CallOperationActionParser.isEmpty(name) ? operation : name;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isAffectingFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof CallOperationAction) {
            CallOperationAction action = (CallOperationAction)element;
            semanticElementsBeingParsed.add(action);
            Operation operation = action.getOperation();
            if (operation != null) {
                semanticElementsBeingParsed.add(operation);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isAffectingFeature(EStructuralFeature feature) {
        return eUML.getNamedElement_Name().equals(feature) || eUML.getCallOperationAction_Operation().equals(feature);
    }

    private static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }
}

