/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DurationLinkFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.GeneralOrderingUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class MessageGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Message message;
        CreateRelationshipRequest createRequest;
        if ((DurationLinkUtil.isCreateDurationLink(request) || GeneralOrderingUtil.isCreateGeneralOrderingLink(request)) && (createRequest = OccurrenceSpecificationUtil.getCreateRelationshipRequest(request)) != null && (message = this.getMessage()) != null) {
            MessageEnd sourceOccurrence;
            MessageEnd messageEnd = sourceOccurrence = OccurrenceSpecificationUtil.isSource(this.getHostFigure(), request.getLocation()) ? message.getSendEvent() : message.getReceiveEvent();
            if (sourceOccurrence instanceof OccurrenceSpecification) {
                Map extendedData = request.getExtendedData();
                extendedData.put("Source Occurrence", sourceOccurrence);
                createRequest.setParameter("Source Occurrence", (Object)sourceOccurrence);
            }
        }
        return super.getConnectionCreateCommand(request);
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        Message message;
        CreateRelationshipRequest createRequest;
        if ((DurationLinkUtil.isCreateDurationLink((CreateConnectionRequest)request) || GeneralOrderingUtil.isCreateGeneralOrderingLink((CreateConnectionRequest)request)) && (createRequest = OccurrenceSpecificationUtil.getCreateRelationshipRequest((CreateConnectionRequest)request)) != null && (message = this.getMessage()) != null) {
            MessageEnd targetOccurrence;
            MessageEnd messageEnd = targetOccurrence = OccurrenceSpecificationUtil.isSource(this.getHostFigure(), request.getLocation()) ? message.getSendEvent() : message.getReceiveEvent();
            if (targetOccurrence instanceof OccurrenceSpecification) {
                Map extendedData = request.getExtendedData();
                extendedData.put("Target Occurrence", targetOccurrence);
                createRequest.setParameter("Target Occurrence", (Object)targetOccurrence);
            }
        }
        return super.getConnectionAndRelationshipCompleteCommand(request);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return super.getReconnectSourceCommand(request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return super.getReconnectTargetCommand(request);
    }

    private Message getMessage() {
        EObject model = EMFHelper.getEObject((Object)this.getHost());
        return model instanceof Message ? (Message)model : null;
    }

    protected Connection createDummyConnection(Request req) {
        if (req instanceof CreateConnectionRequest && DurationLinkUtil.isCreateDurationLink((CreateConnectionRequest)req)) {
            return new DurationLinkFigure();
        }
        return new PolylineConnection();
    }
}

