/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;

public class DeleteCommandHandler
extends AbstractCommandHandler
implements IHandler {
    public static boolean isDeleteEnabled(Collection<EObject> selectedElements) {
        if (selectedElements.size() == 0) {
            return false;
        }
        for (EObject current : selectedElements) {
            if (EMFHelper.isReadOnly((EObject)current)) {
                return false;
            }
            if (current.eContainer() != null) continue;
            return DeleteCommandHandler.isPage(current);
        }
        return true;
    }

    protected static boolean isPage(EObject current) {
        try {
            IPageManager pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)current);
            if (pageManager.allPages().contains(current)) {
                return true;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return false;
    }

    public static Command buildDeleteCommand(Collection<EObject> selectedElements) {
        ICommand gmfCommand = null;
        HashMap parameters = new HashMap();
        for (EObject selectedEObject : selectedElements) {
            IElementEditService provider;
            if (selectedEObject == null || (provider = ElementEditServiceUtils.getCommandProvider((EObject)selectedEObject)) == null) continue;
            DestroyElementRequest request = new DestroyElementRequest(selectedEObject, false);
            request.getParameters().putAll(parameters);
            ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
            gmfCommand = CompositeCommand.compose(gmfCommand, (ICommand)deleteCommand);
            parameters.clear();
            parameters.putAll(request.getParameters());
        }
        if (gmfCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return GMFtoEMFCommandWrapper.wrap((ICommand)gmfCommand.reduce());
    }

    protected Command getCommand(IEvaluationContext context) {
        return DeleteCommandHandler.buildDeleteCommand(this.getSelectedElements());
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        return DeleteCommandHandler.isDeleteEnabled(this.getSelectedElements());
    }
}

