/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.reflect;

import ca.odell.glazedlists.impl.reflect.TypeLiteral;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MoreTypes {
    private static final Map<TypeLiteral<?>, TypeLiteral<?>> PRIMITIVE_TO_WRAPPER;

    private MoreTypes() {
    }

    public static <T> TypeLiteral<T> wrapPrimitives(TypeLiteral<T> typeLiteral) {
        TypeLiteral<?> wrappedPrimitives = PRIMITIVE_TO_WRAPPER.get(typeLiteral);
        return wrappedPrimitives != null ? wrappedPrimitives : typeLiteral;
    }

    public static Type canonicalize(Type type) {
        if (type instanceof ParameterizedTypeImpl) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw MoreTypes.unexpectedType(rawType, Class.class);
            }
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw MoreTypes.unexpectedType(type, ParameterizedType.class);
    }

    private static AssertionError unexpectedType(Type type, Class<?> expected) {
        return new AssertionError((Object)("Unexpected type. Expected: " + expected.getName() + ", got: " + type.getClass().getName() + ", for type literal: " + type.toString() + "."));
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return MoreTypes.equal(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return MoreTypes.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        return false;
    }

    public static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static int hashCode(Type type) {
        if (type instanceof Class) {
            return type.hashCode();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return Arrays.hashCode(p.getActualTypeArguments()) ^ p.getRawType().hashCode() ^ MoreTypes.hashCodeOrZero(p.getOwnerType());
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.hashCode(((GenericArrayType)type).getGenericComponentType());
        }
        return MoreTypes.hashCodeOrZero(type);
    }

    private static int hashCodeOrZero(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String toString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            Type ownerType = parameterizedType.getOwnerType();
            StringBuilder stringBuilder = new StringBuilder();
            if (ownerType != null) {
                stringBuilder.append(MoreTypes.toString(ownerType)).append(".");
            }
            stringBuilder.append(MoreTypes.toString(parameterizedType.getRawType())).append("<").append(MoreTypes.toString(arguments[0]));
            for (int i = 1; i < arguments.length; ++i) {
                stringBuilder.append(", ").append(MoreTypes.toString(arguments[i]));
            }
            return stringBuilder.append(">").toString();
        }
        if (type instanceof GenericArrayType) {
            return MoreTypes.toString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        return type.toString();
    }

    public static Type getGenericSupertype(Type type, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return type;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return MoreTypes.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return MoreTypes.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    public static Type resolveTypeVariable(Type type, Class<?> rawType, TypeVariable unknown) {
        Class<?> declaredByRaw = MoreTypes.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = MoreTypes.getGenericSupertype(type, rawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = Arrays.asList(declaredByRaw.getTypeParameters()).indexOf(unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static Class<?> declaringClassOf(TypeVariable typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    static {
        HashMap<TypeLiteral<Object>, TypeLiteral<Object>> primitiveToWrapper = new HashMap<TypeLiteral<Object>, TypeLiteral<Object>>();
        primitiveToWrapper.put(TypeLiteral.get(Boolean.TYPE), TypeLiteral.get(Boolean.class));
        primitiveToWrapper.put(TypeLiteral.get(Byte.TYPE), TypeLiteral.get(Byte.class));
        primitiveToWrapper.put(TypeLiteral.get(Short.TYPE), TypeLiteral.get(Short.class));
        primitiveToWrapper.put(TypeLiteral.get(Integer.TYPE), TypeLiteral.get(Integer.class));
        primitiveToWrapper.put(TypeLiteral.get(Long.TYPE), TypeLiteral.get(Long.class));
        primitiveToWrapper.put(TypeLiteral.get(Float.TYPE), TypeLiteral.get(Float.class));
        primitiveToWrapper.put(TypeLiteral.get(Double.TYPE), TypeLiteral.get(Double.class));
        primitiveToWrapper.put(TypeLiteral.get(Character.TYPE), TypeLiteral.get(Character.class));
        primitiveToWrapper.put(TypeLiteral.get(Void.TYPE), TypeLiteral.get(Void.class));
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(primitiveToWrapper);
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable {
        private final Type ownerType;
        private final Type rawType;
        private final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type ownerType, Type rawType, Type ... typeArguments) {
            this.ownerType = ownerType == null ? null : MoreTypes.canonicalize(ownerType);
            this.rawType = MoreTypes.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t = 0; t < this.typeArguments.length; ++t) {
                ParameterizedTypeImpl.checkArgument(!(this.typeArguments[t] instanceof Class) || !((Class)this.typeArguments[t]).isPrimitive(), "Parameterized types may not have primitive arguments: %s", this.typeArguments[t]);
                this.typeArguments[t] = MoreTypes.canonicalize(this.typeArguments[t]);
            }
        }

        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public Type getRawType() {
            return this.rawType;
        }

        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && MoreTypes.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return MoreTypes.hashCode(this);
        }

        public String toString() {
            return MoreTypes.toString(this);
        }

        private static void checkArgument(boolean expression, String errorMessageFormat, Object ... errorMessageArgs) {
            if (!expression) {
                throw new IllegalArgumentException(String.format(errorMessageFormat, errorMessageArgs));
            }
        }
    }
}

