/**
 * Copyright (c) 2014 Anatoliy Tischenko and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Anatoliy Tischenko - Initial API and implementation
 */
package aspects.xpt.expressions;

import aspects.xpt.Common;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class AbstractExpression extends xpt.expressions.AbstractExpression {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence performCast(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(
      "Expression may return number value which is not directly compatible with feature type (e.g. Double when Integer is expected), or EEnumLiteral meta-object when literal instance is expected");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static Object performCast(Object value, org.eclipse.emf.ecore.EDataType targetType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (targetType instanceof org.eclipse.emf.ecore.EEnum) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (value instanceof org.eclipse.emf.ecore.EEnumLiteral) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.ecore.EEnumLiteral literal = (org.eclipse.emf.ecore.EEnumLiteral) value;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (literal.getInstance() != null) ? literal.getInstance() : literal;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (false == value instanceof Number || targetType == null || targetType.getInstanceClass() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> targetClass = targetType.getInstanceClass();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Number num = (Number) value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> valClass = value.getClass();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Class<?> targetWrapperClass = targetClass;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (targetClass.isPrimitive()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("targetWrapperClass = org.eclipse.emf.ecore.util.EcoreUtil.wrapperClassFor(targetClass);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (valClass.equals(targetWrapperClass)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (Number.class.isAssignableFrom(targetWrapperClass)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Byte.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Byte(num.byteValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Integer.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Integer(num.intValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Short.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Short(num.shortValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Long.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Long(num.longValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(java.math.BigInteger.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return java.math.BigInteger.valueOf(num.longValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Float.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Float(num.floatValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(Double.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new Double(num.doubleValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (targetWrapperClass.equals(java.math.BigDecimal.class)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new java.math.BigDecimal(num.doubleValue());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return value;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
