/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.transform;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.BasicGenModelAccess;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.DummyGenModel;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.FileGenModelAccess;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.GenModelAccess;
import org.eclipse.papyrus.gmf.internal.bridge.transform.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.ui.Plugin;
import org.eclipse.papyrus.gmf.mappings.Mapping;

public class GenModelDetector {
    private final Mapping myMapping;
    private GenModelAccess myGMAccess;
    private Collection<EPackage> myPackages;

    public GenModelDetector(Mapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("Could not detect with null Mapping");
        }
        this.myMapping = mapping;
    }

    public IStatus detect() {
        this.myPackages = this.findEPackages(this.myMapping);
        if (this.myPackages.isEmpty()) {
            this.myGMAccess = new GenModelAccess.Adapter(null);
            return Status.OK_STATUS;
        }
        if (this.myPackages.size() == 1) {
            EPackage solePack = this.myPackages.iterator().next();
            BasicGenModelAccess gma = new BasicGenModelAccess(solePack);
            gma.initDefault();
            return this.apply((GenModelAccess)gma);
        }
        return Plugin.createError(Messages.GenModelDetector_e_not_found, null);
    }

    public IStatus advise(URI genModelURI) {
        if (genModelURI == null) {
            throw new IllegalArgumentException("Null GenModel URI");
        }
        FileGenModelAccess gma = new FileGenModelAccess(genModelURI);
        return this.apply((GenModelAccess)gma);
    }

    public IStatus advise(IFile workspaceFile) {
        if (workspaceFile == null) {
            throw new IllegalArgumentException("Null GenModel file");
        }
        FileGenModelAccess gma = new FileGenModelAccess(workspaceFile);
        return this.apply((GenModelAccess)gma);
    }

    private Collection<EPackage> findEPackages(Mapping mapping) {
        HashSet<EPackage> packages = new HashSet<EPackage>();
        for (EObject next : EcoreUtil.ExternalCrossReferencer.find((EObject)mapping).keySet()) {
            if (!(next instanceof EClass)) continue;
            packages.add(((EClass)next).getEPackage());
        }
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            EPackage next = (EPackage)it.next();
            if (next.getESuperPackage() == null || !EcoreUtil.isAncestor(packages, (EObject)next.getESuperPackage())) continue;
            it.remove();
        }
        return packages;
    }

    private IStatus apply(GenModelAccess gma) {
        IStatus load = gma.load((ResourceSet)new ResourceSetImpl());
        if (load.isOK()) {
            gma.unload();
            this.myGMAccess = gma;
            return Status.OK_STATUS;
        }
        return load;
    }

    private EPackage getPrimaryPackage() {
        if (this.myPackages == null || this.myPackages.size() == 0) {
            return null;
        }
        return this.myPackages.iterator().next();
    }

    public boolean canCreateDefault() {
        return this.myPackages != null && this.myPackages.size() == 1;
    }

    public URI createDefault(String pluginID, IFile patternResource) throws CoreException {
        DummyGenModel gma = new DummyGenModel(this.getPrimaryPackage(), null);
        gma.setPluginID(pluginID);
        GenModel model = gma.create();
        IPath path = patternResource.getFullPath().removeFileExtension().addFileExtension("genmodel");
        URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        Resource res = new ResourceSetImpl().createResource(uri, "");
        res.getContents().add((Object)model);
        try {
            res.save(null);
            return uri;
        }
        catch (IOException ex) {
            IStatus error = Plugin.createError(Messages.GenModelDetector_e_save, ex);
            throw new CoreException(error);
        }
    }

    public GenModel get(ResourceSet resSet) {
        if (this.myGMAccess == null) {
            throw new IllegalStateException(Messages.GenModelDetector_e_no_genmodelaccess);
        }
        IStatus s = this.myGMAccess.load(resSet);
        if (!s.isOK()) {
            throw new IllegalStateException(s.getMessage());
        }
        return this.myGMAccess.model();
    }
}

