/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.wizards;

import org.eclipse.papyrus.gmf.internal.common.ui.ResourceLocationProvider;

public final class WizardOperationMode {
    public static final String DETECT = "detect";
    public static final String CREATE = "create";
    public static final String RECONCILE = "reconcile";
    private String fileExtension;
    private String mode;

    public WizardOperationMode(String fileExtension, String mode) {
        assert (fileExtension != null);
        WizardOperationMode.assertCorrectMode(mode);
        this.fileExtension = fileExtension;
        this.mode = mode;
    }

    public void setMode(String mode) {
        WizardOperationMode.assertCorrectMode(mode);
        if (mode == null) {
            throw new IllegalStateException("Operation mode already detected");
        }
        this.mode = mode;
    }

    public boolean detectReconcile(ResourceLocationProvider rloc) {
        boolean reconcileMode;
        if (this.mode == null) {
            throw new IllegalStateException("Operation mode could be detected only once");
        }
        if (DETECT.equals(this.mode)) {
            reconcileMode = !rloc.getSelectedURIs(this.fileExtension, true).isEmpty();
        } else if (CREATE.equals(this.mode)) {
            reconcileMode = false;
        } else if (RECONCILE.equals(this.mode)) {
            reconcileMode = true;
        } else {
            throw new IllegalStateException("Illegal mode: " + this.mode);
        }
        this.mode = null;
        return reconcileMode;
    }

    public static void assertCorrectMode(String mode) {
        assert (DETECT.equals(mode) || CREATE.equals(mode) || RECONCILE.equals(mode));
    }
}

