/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.gmfgraph.Border;
import org.eclipse.papyrus.gmf.gmfgraph.BorderRef;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.Compartment;
import org.eclipse.papyrus.gmf.gmfgraph.CompoundBorder;
import org.eclipse.papyrus.gmf.gmfgraph.Connection;
import org.eclipse.papyrus.gmf.gmfgraph.CustomBorder;
import org.eclipse.papyrus.gmf.gmfgraph.CustomFigure;
import org.eclipse.papyrus.gmf.gmfgraph.CustomLayout;
import org.eclipse.papyrus.gmf.gmfgraph.DiagramLabel;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureGallery;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.papyrus.gmf.gmfgraph.LayoutRef;
import org.eclipse.papyrus.gmf.gmfgraph.Node;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.papyrus.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.papyrus.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.DefaultViewmapProducer;

public class InnerClassViewmapProducer
extends DefaultViewmapProducer {
    private final FigureGenerator figureGenerator;
    private final int[] figuresWithExtraRTBehaviour;

    public InnerClassViewmapProducer() {
        this(null, MapModeCodeGenStrategy.DYNAMIC, null);
    }

    public InnerClassViewmapProducer(String runtimeToken, MapModeCodeGenStrategy mapModeCodeGenStrategy, URL[] dynamicFigureTemplates) {
        this.figureGenerator = new FigureGenerator(runtimeToken, null, mapModeCodeGenStrategy, null, true, dynamicFigureTemplates);
        if (runtimeToken == null || "full".equalsIgnoreCase(runtimeToken)) {
            this.figuresWithExtraRTBehaviour = new int[]{34, 24};
            Arrays.sort(this.figuresWithExtraRTBehaviour);
        } else {
            this.figuresWithExtraRTBehaviour = new int[0];
        }
    }

    @Override
    public Viewmap create(Node node) {
        if (node.getFigure() == null) {
            return super.create(node);
        }
        Viewmap viewmap = this.createViewmap(node.getFigure());
        this.setupResizeConstraints(viewmap, node);
        this.setupLayoutType(viewmap, node);
        this.setupDefaultSize(viewmap, node);
        return viewmap;
    }

    @Override
    public Viewmap create(Connection link) {
        if (link.getFigure() == null) {
            return super.create(link);
        }
        return this.createViewmap(link.getFigure());
    }

    @Override
    public Viewmap create(DiagramLabel diagramLabel) {
        if (diagramLabel.getFigure() == null) {
            return super.create(diagramLabel);
        }
        if (diagramLabel.getAccessor() == null) {
            return this.createViewmap(diagramLabel.getFigure());
        }
        return this.createViewmap(diagramLabel.getFigure(), diagramLabel.getAccessor());
    }

    @Override
    public Viewmap create(Compartment compartment) {
        if (compartment.getFigure() == null) {
            return super.create(compartment);
        }
        if (compartment.getAccessor() == null) {
            return this.createViewmap(compartment.getFigure());
        }
        return this.createViewmap(compartment.getFigure(), compartment.getAccessor());
    }

    private Viewmap createViewmap(FigureDescriptor figureDescriptor) {
        FigureViewmap result;
        if (figureDescriptor.getActualFigure() == null) {
            throw new NullPointerException();
        }
        Figure figure = figureDescriptor.getActualFigure();
        if (figure instanceof RealFigure && InnerClassViewmapProducer.isBareInstance((RealFigure)figure)) {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName(this.figureGenerator.fqnSwitch(figure));
            result = v;
        } else {
            InnerClassViewmap v = GMFGenFactory.eINSTANCE.createInnerClassViewmap();
            v.setClassBody(this.figureGenerator.go(figureDescriptor));
            v.setClassName(InnerClassViewmapProducer.getCompilationUnitName(figureDescriptor));
            result = v;
        }
        this.setupPluginDependencies((Viewmap)result, figureDescriptor.getActualFigure());
        this.setupStyleAttributes((Viewmap)result, figureDescriptor.getActualFigure());
        return result;
    }

    private Viewmap createViewmap(FigureDescriptor owner, ChildAccess labelAccess) {
        ParentAssignedViewmap v = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
        v.setGetterName(labelAccess.getAccessor());
        v.setFigureQualifiedClassName(this.figureGenerator.fqnSwitch(labelAccess.getFigure()));
        this.setupStyleAttributes((Viewmap)v, labelAccess.getFigure());
        return v;
    }

    private void setupPluginDependencies(Viewmap viewmap, Figure figure) {
        for (FigureGallery gallery : InnerClassViewmapProducer.findAllGalleriesForImport(figure)) {
            if (gallery.getImplementationBundle() == null) continue;
            this.myDependencies.add(gallery.getImplementationBundle());
        }
        if (this.figuresWithExtraRTBehaviour.length > 0 && Arrays.binarySearch(this.figuresWithExtraRTBehaviour, figure.eClass().getClassifierID()) >= 0) {
            this.myDependencies.add("org.eclipse.gmf.runtime.draw2d.ui");
        }
    }

    public static Collection<FigureGallery> findAllGalleriesForImport(Figure figure) {
        LinkedHashSet<FigureGallery> rv = new LinkedHashSet<FigureGallery>();
        rv.add(InnerClassViewmapProducer.findAncestorFigureGallery((EObject)figure));
        LinkedList<Figure> queue = new LinkedList<Figure>();
        queue.add(figure);
        do {
            RealFigure fig;
            if (queue.peek() instanceof RealFigure) {
                fig = (RealFigure)queue.removeFirst();
            } else if (queue.peek() instanceof FigureRef) {
                fig = ((FigureRef)queue.removeFirst()).getFigure();
            } else {
                assert (false);
                queue.removeFirst();
                continue;
            }
            if (fig.getLayout() instanceof LayoutRef && ((LayoutRef)fig.getLayout()).getActual() instanceof CustomLayout) {
                rv.add(InnerClassViewmapProducer.findAncestorFigureGallery((EObject)((LayoutRef)fig.getLayout()).getActual()));
            }
            if (fig.getBorder() != null) {
                LinkedList<Border> borderQueue = new LinkedList<Border>();
                borderQueue.add(fig.getBorder());
                do {
                    if (borderQueue.peek() instanceof BorderRef) {
                        borderQueue.add(((BorderRef)borderQueue.peek()).getActual());
                    } else if (borderQueue.peek() instanceof CompoundBorder) {
                        CompoundBorder b = (CompoundBorder)borderQueue.peek();
                        borderQueue.addLast(b.getInner());
                        borderQueue.addLast(b.getOuter());
                    } else if (borderQueue.peek() instanceof CustomBorder) {
                        rv.add(InnerClassViewmapProducer.findAncestorFigureGallery((EObject)borderQueue.peek()));
                    }
                    borderQueue.removeFirst();
                } while (!borderQueue.isEmpty());
            }
            queue.addAll((Collection<Figure>)fig.getChildren());
        } while (!queue.isEmpty());
        rv.remove(null);
        return rv;
    }

    public static FigureGallery findAncestorFigureGallery(EObject figure) {
        EObject current = figure;
        EObject next;
        while ((next = current.eContainer()) != null) {
            if (next instanceof FigureGallery) {
                return (FigureGallery)next;
            }
            current = next;
        }
        return null;
    }

    private static String getCompilationUnitName(FigureDescriptor fd) {
        return CodeGenUtil.validJavaIdentifier((String)CodeGenUtil.capName((String)fd.getName()));
    }

    private static boolean isBareInstance(RealFigure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Name());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Children());
        if (figure instanceof CustomFigure) {
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomFigure_CustomChildren());
        }
        for (EStructuralFeature next : featuresToCheck) {
            if (next.isDerived() || !figure.eIsSet(next)) continue;
            return false;
        }
        return true;
    }
}

