/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.gmfgraph.Border;
import org.eclipse.papyrus.gmf.gmfgraph.BorderLayout;
import org.eclipse.papyrus.gmf.gmfgraph.CenterLayout;
import org.eclipse.papyrus.gmf.gmfgraph.CustomBorder;
import org.eclipse.papyrus.gmf.gmfgraph.CustomFigure;
import org.eclipse.papyrus.gmf.gmfgraph.CustomLayout;
import org.eclipse.papyrus.gmf.gmfgraph.Ellipse;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureRef;
import org.eclipse.papyrus.gmf.gmfgraph.FlowLayout;
import org.eclipse.papyrus.gmf.gmfgraph.GridLayout;
import org.eclipse.papyrus.gmf.gmfgraph.GridLayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.InvisibleRectangle;
import org.eclipse.papyrus.gmf.gmfgraph.Label;
import org.eclipse.papyrus.gmf.gmfgraph.LabeledContainer;
import org.eclipse.papyrus.gmf.gmfgraph.Layout;
import org.eclipse.papyrus.gmf.gmfgraph.LayoutData;
import org.eclipse.papyrus.gmf.gmfgraph.Polygon;
import org.eclipse.papyrus.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.Polyline;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineConnection;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.Rectangle;
import org.eclipse.papyrus.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.papyrus.gmf.gmfgraph.SVGFigure;
import org.eclipse.papyrus.gmf.gmfgraph.ScalablePolygon;
import org.eclipse.papyrus.gmf.gmfgraph.StackLayout;
import org.eclipse.papyrus.gmf.gmfgraph.VerticalLabel;
import org.eclipse.papyrus.gmf.gmfgraph.XYLayout;
import org.eclipse.papyrus.gmf.gmfgraph.XYLayoutData;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Runtime {
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  protected CharSequence _newInstance(final Figure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append(" ");
    _builder.append(figureVarName);
    _builder.append(" = ");
    CharSequence _newInstance = this.newInstance(it);
    _builder.append(_newInstance);
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _newInstance(final Figure it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new ");
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append("()");
    return _builder;
  }
  
  protected CharSequence _newInstance(final Layout it, final String layoutVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append(" ");
    _builder.append(layoutVarName);
    _builder.append(" = ");
    CharSequence _newInstance = this.newInstance(it);
    _builder.append(_newInstance);
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _newInstance(final Layout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new ");
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append("()");
    return _builder;
  }
  
  protected CharSequence _newInstance(final LayoutData it, final String constraintVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append(" ");
    _builder.append(constraintVarName);
    _builder.append(" = ");
    CharSequence _newInstance = this.newInstance(it);
    _builder.append(_newInstance);
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _newInstance(final LayoutData it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new ");
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append("()");
    return _builder;
  }
  
  protected CharSequence _newInstance(final Border it, final String borderVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append(" ");
    _builder.append(borderVarName);
    _builder.append(" = ");
    CharSequence _newInstance = this.newInstance(it);
    _builder.append(_newInstance);
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _newInstance(final Border it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new ");
    CharSequence _fqn = this.fqn(it);
    _builder.append(_fqn);
    _builder.append("()");
    return _builder;
  }
  
  protected CharSequence _fqn(final Figure it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract definition fqn(Figure)");
    return _builder;
  }
  
  protected CharSequence _fqn(final Layout it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract definition fqn(Layout)");
    return _builder;
  }
  
  protected CharSequence _fqn(final LayoutData it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract definition fqn(LayoutData)");
    return _builder;
  }
  
  protected CharSequence _fqn(final Border it) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR("Abstract definition fqn(Border)");
    return _builder;
  }
  
  protected CharSequence _fqn(final CustomLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _fqn(final CustomBorder it) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _fqn(final CustomFigure it) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedClassName = it.getQualifiedClassName();
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _fqn(final FlowLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isForceSingleLine = it.isForceSingleLine();
      if (_isForceSingleLine) {
        _builder.append("org.eclipse.draw2d.ToolbarLayout");
      } else {
        _builder.append("org.eclipse.draw2d.FlowLayout");
      }
    }
    return _builder;
  }
  
  protected CharSequence _fqn(final XYLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.XYLayout");
    return _builder;
  }
  
  protected CharSequence _fqn(final XYLayoutData it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.geometry.Rectangle");
    return _builder;
  }
  
  protected CharSequence _fqn(final GridLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.GridLayout");
    return _builder;
  }
  
  protected CharSequence _fqn(final GridLayoutData it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.GridData");
    return _builder;
  }
  
  protected CharSequence _fqn(final StackLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.StackLayout");
    return _builder;
  }
  
  protected CharSequence _fqn(final BorderLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.BorderLayout");
    return _builder;
  }
  
  /**
   * CenterLayout requires dependency to tooling runtime if the stabdalone plugin is generated
   */
  protected CharSequence _fqn(final CenterLayout it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.tooling.runtime.draw2d.CenterLayout");
    return _builder;
  }
  
  protected CharSequence _fqn(final FigureRef it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _fqn = this.fqn(it.getFigure());
    _builder.append(_fqn);
    return _builder;
  }
  
  protected CharSequence _fqn(final Label it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isFullRuntime = this._utils_qvto.isFullRuntime();
      if (_isFullRuntime) {
        _builder.append("org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel");
      } else {
        _builder.append("org.eclipse.draw2d.Label");
      }
    }
    return _builder;
  }
  
  protected CharSequence _fqn(final VerticalLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.tooling.runtime.draw2d.labels.VerticalLabel");
    return _builder;
  }
  
  protected CharSequence _fqn(final LabeledContainer it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.LabeledContainer");
    return _builder;
  }
  
  protected CharSequence _fqn(final Rectangle it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.RectangleFigure");
    return _builder;
  }
  
  protected CharSequence _fqn(final RoundedRectangle it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.RoundedRectangle");
    return _builder;
  }
  
  protected CharSequence _fqn(final InvisibleRectangle it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.RectangleFigure");
    return _builder;
  }
  
  protected CharSequence _fqn(final Ellipse it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.Ellipse");
    return _builder;
  }
  
  protected CharSequence _fqn(final Polygon it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.PolygonShape");
    return _builder;
  }
  
  protected CharSequence _fqn(final ScalablePolygon it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.ScalablePolygonShape");
    return _builder;
  }
  
  protected CharSequence _fqn(final PolygonDecoration it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.PolygonDecoration");
    return _builder;
  }
  
  protected CharSequence _fqn(final Polyline it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.PolylineShape");
    return _builder;
  }
  
  protected CharSequence _fqn(final PolylineDecoration it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.PolylineDecoration");
    return _builder;
  }
  
  protected CharSequence _fqn(final PolylineConnection it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isFullRuntime = this._utils_qvto.isFullRuntime();
      if (_isFullRuntime) {
        _builder.append("org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx");
      } else {
        _builder.append("org.eclipse.draw2d.PolylineConnection");
      }
    }
    return _builder;
  }
  
  protected CharSequence _fqn(final SVGFigure it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.lite.svg.SVGFigure");
    return _builder;
  }
  
  public CharSequence newInstance(final EObject it, final String figureVarName) {
    if (it instanceof Figure) {
      return _newInstance((Figure)it, figureVarName);
    } else if (it instanceof Border) {
      return _newInstance((Border)it, figureVarName);
    } else if (it instanceof Layout) {
      return _newInstance((Layout)it, figureVarName);
    } else if (it instanceof LayoutData) {
      return _newInstance((LayoutData)it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
  
  public CharSequence newInstance(final EObject it) {
    if (it instanceof Figure) {
      return _newInstance((Figure)it);
    } else if (it instanceof Border) {
      return _newInstance((Border)it);
    } else if (it instanceof Layout) {
      return _newInstance((Layout)it);
    } else if (it instanceof LayoutData) {
      return _newInstance((LayoutData)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence fqn(final EObject it) {
    if (it instanceof PolygonDecoration) {
      return _fqn((PolygonDecoration)it);
    } else if (it instanceof ScalablePolygon) {
      return _fqn((ScalablePolygon)it);
    } else if (it instanceof Polygon) {
      return _fqn((Polygon)it);
    } else if (it instanceof PolylineConnection) {
      return _fqn((PolylineConnection)it);
    } else if (it instanceof PolylineDecoration) {
      return _fqn((PolylineDecoration)it);
    } else if (it instanceof Ellipse) {
      return _fqn((Ellipse)it);
    } else if (it instanceof Polyline) {
      return _fqn((Polyline)it);
    } else if (it instanceof Rectangle) {
      return _fqn((Rectangle)it);
    } else if (it instanceof RoundedRectangle) {
      return _fqn((RoundedRectangle)it);
    } else if (it instanceof CustomFigure) {
      return _fqn((CustomFigure)it);
    } else if (it instanceof InvisibleRectangle) {
      return _fqn((InvisibleRectangle)it);
    } else if (it instanceof Label) {
      return _fqn((Label)it);
    } else if (it instanceof LabeledContainer) {
      return _fqn((LabeledContainer)it);
    } else if (it instanceof SVGFigure) {
      return _fqn((SVGFigure)it);
    } else if (it instanceof VerticalLabel) {
      return _fqn((VerticalLabel)it);
    } else if (it instanceof FigureRef) {
      return _fqn((FigureRef)it);
    } else if (it instanceof CustomBorder) {
      return _fqn((CustomBorder)it);
    } else if (it instanceof CustomLayout) {
      return _fqn((CustomLayout)it);
    } else if (it instanceof BorderLayout) {
      return _fqn((BorderLayout)it);
    } else if (it instanceof CenterLayout) {
      return _fqn((CenterLayout)it);
    } else if (it instanceof Figure) {
      return _fqn((Figure)it);
    } else if (it instanceof FlowLayout) {
      return _fqn((FlowLayout)it);
    } else if (it instanceof GridLayout) {
      return _fqn((GridLayout)it);
    } else if (it instanceof GridLayoutData) {
      return _fqn((GridLayoutData)it);
    } else if (it instanceof StackLayout) {
      return _fqn((StackLayout)it);
    } else if (it instanceof XYLayout) {
      return _fqn((XYLayout)it);
    } else if (it instanceof XYLayoutData) {
      return _fqn((XYLayoutData)it);
    } else if (it instanceof Border) {
      return _fqn((Border)it);
    } else if (it instanceof Layout) {
      return _fqn((Layout)it);
    } else if (it instanceof LayoutData) {
      return _fqn((LayoutData)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
