/**
 * Copyright (c) 2006-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.edithelpers;

import com.google.inject.Inject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@SuppressWarnings("all")
public class EditHelper {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private BaseEditHelper xptBaseEditHelper;
  
  public CharSequence className(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editHelperClassName = it.getEditHelperClassName();
    _builder.append(_editHelperClassName);
    return _builder;
  }
  
  public CharSequence packageName(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editHelpersPackageName = it.getDiagramElement().getDiagram().getEditHelpersPackageName();
    _builder.append(_editHelpersPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence EditHelper(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagramElement().getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends ");
    CharSequence _qualifiedClassName = this.xptBaseEditHelper.qualifiedClassName(it.getDiagramElement().getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final MetamodelType it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
