/*******************************************************************************
 * Copyright (c) 2005, 2020 Borland Software Corporation, CEA LIST, ARTAL
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *     Borland - initial API and implementation
 *     Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 ******************************************************************************/
/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.papyrus.gmf.mappings;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.tooldef.StyleSelector;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Appearance Steward</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.papyrus.gmf.mappings.AppearanceSteward#getAppearanceStyle <em>Appearance Style</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.papyrus.gmf.mappings.GMFMapPackage#getAppearanceSteward()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface AppearanceSteward extends EObject {
	/**
	 * Returns the value of the '<em><b>Appearance Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Appearance Style</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Appearance Style</em>' reference.
	 * @see #setAppearanceStyle(StyleSelector)
	 * @see org.eclipse.papyrus.gmf.mappings.GMFMapPackage#getAppearanceSteward_AppearanceStyle()
	 * @model
	 * @generated
	 */
	StyleSelector getAppearanceStyle();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.gmf.mappings.AppearanceSteward#getAppearanceStyle <em>Appearance Style</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Appearance Style</em>' reference.
	 * @see #getAppearanceStyle()
	 * @generated
	 */
	void setAppearanceStyle(StyleSelector value);

} // AppearanceSteward
