/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.properties.Activator;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public class TableLabelObservableValue
extends AbstractObservableValue
implements IObserving,
ReferenceCountedObservable {
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support((IObservable)this);
    protected Table table;
    protected EditingDomain domain;
    protected Adapter listener;
    protected InternationalizationEntry entry;

    public TableLabelObservableValue(Table table) {
        this(Realm.getDefault(), table);
    }

    public TableLabelObservableValue(Realm realm, Table table) {
        super(realm);
        this.table = table;
        this.domain = TableEditingDomainUtils.getTableEditingDomain((Table)table);
        this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)table, (Object)table);
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.entry.eAdapters().remove((Object)this.listener);
            this.listener = null;
        }
        this.entry = null;
        this.table = null;
        super.dispose();
    }

    public Object getObserved() {
        return this.table;
    }

    protected void firstListenerAdded() {
        if (this.entry != null) {
            if (this.listener == null) {
                this.listener = new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        if (InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value() == notification.getFeature() && !notification.isTouch()) {
                            final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                            TableLabelObservableValue.this.getRealm().exec(new Runnable(){

                                @Override
                                public void run() {
                                    TableLabelObservableValue.this.fireValueChange(diff);
                                }
                            });
                        }
                    }
                };
            }
            this.entry.eAdapters().add((Object)this.listener);
        }
    }

    protected Object doGetValue() {
        return LabelInternationalization.getInstance().getTableLabelWithoutName(this.table);
    }

    protected void doSetValue(Object value) {
        try {
            if (this.entry != null && this.listener != null) {
                this.entry.eAdapters().remove((Object)this.listener);
            }
            Command emfCommand = LabelInternationalization.getInstance().getSetTableLabelCommand(this.domain, this.table, (String)value, null);
            this.domain.getCommandStack().execute(emfCommand);
            this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)this.table, (Object)this.table);
            this.firstListenerAdded();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Object getValueType() {
        return null;
    }

    public void retain() {
        this.refCount.retain();
    }

    public void release() {
        this.refCount.release();
    }

    public void autorelease() {
        this.refCount.autorelease();
    }
}

