/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.services.validation.commands.AsyncValidateSubtreeCommand;
import org.eclipse.papyrus.uml.xtext.integration.IXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.papyrus.uml.xtext.integration.ui.Activator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class DefaultXtextParser
implements IParser {
    protected final IXtextDirectEditorConfiguration editorConfiguration;
    protected final EObject semanticObject;
    protected final boolean ignoreValidationStep;

    public DefaultXtextParser(IXtextDirectEditorConfiguration editorConfiguration, EObject semanticEObject) {
        this(editorConfiguration, semanticEObject, false);
    }

    public DefaultXtextParser(IXtextDirectEditorConfiguration editorConfiguration, EObject semanticEObject, boolean ignoreValidationStep) {
        this.editorConfiguration = editorConfiguration;
        this.semanticObject = semanticEObject;
        this.ignoreValidationStep = ignoreValidationStep;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.editorConfiguration.getTextToEditInternal(this.semanticObject);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        CompositeCommand result = new CompositeCommand("validation");
        ContextElementAdapter.IContextElementProvider provider = this.editorConfiguration.getContextProvider();
        XtextFakeResourceContext context = new XtextFakeResourceContext(this.editorConfiguration.getInjector());
        XtextResource xtextResource = context.getFakeResource();
        xtextResource.eAdapters().add((Object)new ContextElementAdapter(provider));
        try {
            xtextResource.load((InputStream)new StringInputStream(newString), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
            ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
        }
        EcoreUtil2.resolveLazyCrossReferences((Resource)xtextResource, (CancelIndicator)CancelIndicator.NullImpl);
        IParseResult parseResult = xtextResource.getParseResult();
        if (this.ignoreValidationStep) {
            EObject xtextObject = parseResult.getRootASTElement();
            ICommand cmd = this.editorConfiguration.getParseCommand(this.semanticObject, xtextObject);
            if (cmd != null) {
                result.add((IUndoableOperation)cmd);
            }
        } else {
            IResourceValidator resVal = xtextResource.getResourceServiceProvider().getResourceValidator();
            List issues = resVal.validate((Resource)xtextResource, CheckMode.ALL, CancelIndicator.NullImpl);
            EList errors = context.getFakeResource().getErrors();
            if (!parseResult.hasSyntaxErrors() && errors.size() == 0 && issues.size() == 0) {
                EObject xtextObject = parseResult.getRootASTElement();
                ICommand cmd = this.editorConfiguration.getParseCommand(this.semanticObject, xtextObject);
                if (cmd != null) {
                    result.add((IUndoableOperation)cmd);
                }
            } else {
                result.add((IUndoableOperation)this.editorConfiguration.createInvalidStringCommand(newString, this.semanticObject, parseResult, (List<Resource.Diagnostic>)errors, issues));
            }
            AsyncValidateSubtreeCommand validationCommand = new AsyncValidateSubtreeCommand(this.semanticObject);
            validationCommand.disableUIFeedback();
            result.add((IUndoableOperation)validationCommand);
        }
        return result;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.editorConfiguration.getTextToEdit(this.semanticObject);
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return null;
    }
}

