/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - introduced GenAuditContext entity straightforward and simple #validate() implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.providers;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.GenAuditRoot_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class ValidationProvider extends xpt.providers.ValidationProvider {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private GenAuditRoot_qvto _genAuditRoot_qvto;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private Activator xptActivator;
  
  @Override
  public CharSequence selectors(final GenAuditRoot it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(it, null));
      if (_notEquals) {
        {
          EList<GenAuditContext> _clientContexts = it.getClientContexts();
          boolean _notEquals_1 = (!Objects.equal(_clientContexts, null));
          if (_notEquals_1) {
            {
              EList<GenAuditContext> _clientContexts_1 = it.getClientContexts();
              for(final GenAuditContext ctx : _clientContexts_1) {
                CharSequence _generatedMemberComment = this._common.generatedMemberComment();
                _builder.append(_generatedMemberComment);
                _builder.newLineIfNotEmpty();
                _builder.append("public static class ");
                String _className = ctx.getClassName();
                _builder.append(_className);
                _builder.append(" implements org.eclipse.emf.validation.model.IClientSelector {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t");
                CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
                _builder.append(_generatedMemberComment_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("public boolean selects(Object object) {");
                _builder.newLine();
                {
                  boolean _notEmpty = this._common_qvto.<GenDiagramElementTarget>notEmpty(Iterables.<GenDiagramElementTarget>filter(ctx.getRuleTargets(), GenDiagramElementTarget.class));
                  if (_notEmpty) {
                    _builder.append("\t");
                    _builder.append("if (isInDefaultEditorContext(object) && object instanceof org.eclipse.gmf.runtime.notation.View) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("final String id = ");
                    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
                    _builder.append(_visualIDMethodCall, "\t\t");
                    _builder.append("((org.eclipse.gmf.runtime.notation.View) object);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("boolean result = false;");
                    _builder.newLine();
                    {
                      Iterable<GenCommonBase> _targetDiagramElements = this._genAuditRoot_qvto.getTargetDiagramElements(ctx);
                      for(final GenCommonBase e : _targetDiagramElements) {
                        _builder.append("\t");
                        _builder.append("result = result || ");
                        CharSequence _visualID = VisualIDRegistry.visualID(e);
                        _builder.append(_visualID, "\t");
                        _builder.append(".equals(id);");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("return false;");
                    _builder.newLine();
                  } else {
                    _builder.append("\t");
                    _builder.append("return isInDefaultEditorContext(object);");
                    _builder.newLine();
                  }
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence constraintAdapters(final GenAuditRoot it, final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(it, null));
      if (_notEquals) {
        {
          GenExpressionProviderContainer _expressionProviders = diagram.getEditorGen().getExpressionProviders();
          boolean _notEquals_1 = (!Objects.equal(_expressionProviders, null));
          if (_notEquals_1) {
            {
              final Function1<GenAuditRule, Boolean> _function = new Function1<GenAuditRule, Boolean>() {
                @Override
                public Boolean apply(final GenAuditRule a) {
                  return Boolean.valueOf(a.isRequiresConstraintAdapter());
                }
              };
              Iterable<GenAuditRule> _filter = IterableExtensions.<GenAuditRule>filter(it.getRules(), _function);
              for(final GenAuditRule next : _filter) {
                CharSequence _constraintAdapter = this.constraintAdapter(next, diagram.getEditorGen().getExpressionProviders());
                _builder.append(_constraintAdapter);
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.newLine();
            {
              final Function1<GenAuditRule, Boolean> _function_1 = new Function1<GenAuditRule, Boolean>() {
                @Override
                public Boolean apply(final GenAuditRule a) {
                  return Boolean.valueOf(a.isRequiresConstraintAdapter());
                }
              };
              boolean _exists = IterableExtensions.<GenAuditRule>exists(it.getRules(), _function_1);
              if (_exists) {
                CharSequence _constraintAdapters_formatMethod = this.constraintAdapters_formatMethod(it);
                _builder.append(_constraintAdapters_formatMethod);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence runWithActiveConstraints(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static void runWithConstraints(org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain, Runnable operation) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final Runnable op = operation;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Runnable task = new Runnable() {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("constraintsActive = true;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("op.run();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} finally {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("constraintsActive = false;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(editingDomain != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("editingDomain.runExclusive(task);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (Exception e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".getInstance().logError(\"Validation failed\", e); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("task.run();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence strategy_support(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasDiagramElementTargetRule = this._genAuditRoot_qvto.hasDiagramElementTargetRule(it.getEditorGen().getAudits());
      if (_hasDiagramElementTargetRule) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static org.eclipse.emf.validation.service.ITraversalStrategy getNotationTraversalStrategy(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.validation.service.IBatchValidator validator) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new CtxSwitchStrategy(validator);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private static class CtxSwitchStrategy implements org.eclipse.emf.validation.service.ITraversalStrategy {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.emf.validation.service.ITraversalStrategy defaultStrategy;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private String currentSemanticCtxId;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private boolean ctxChanged = true;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.emf.ecore.EObject currentTarget;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private org.eclipse.emf.ecore.EObject preFetchedNextTarget;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_7, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private final String[] contextSwitchingIdentifiers;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CtxSwitchStrategy(org.eclipse.emf.validation.service.IBatchValidator validator) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.defaultStrategy = validator.getDefaultTraversalStrategy();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.contextSwitchingIdentifiers = new String[] {");
        _builder.newLine();
        _builder.append("\t\t\t");
        {
          Iterable<GenCommonBase> _allTargetDiagramElements = this._genAuditRoot_qvto.getAllTargetDiagramElements(it.getEditorGen().getAudits());
          boolean _hasElements = false;
          for(final GenCommonBase e : _allTargetDiagramElements) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "\t\t\t");
            }
            CharSequence _visualID = VisualIDRegistry.visualID(e);
            _builder.append(_visualID, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("java.util.Arrays.sort(this.contextSwitchingIdentifiers);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_9, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void elementValidated(org.eclipse.emf.ecore.EObject element,");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("org.eclipse.core.runtime.IStatus status) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("defaultStrategy.elementValidated(element, status);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_10, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean hasNext() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return defaultStrategy.hasNext();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_11, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public boolean isClientContextChanged() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (preFetchedNextTarget == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("preFetchedNextTarget = next();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("prepareNextClientContext(preFetchedNextTarget);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ctxChanged;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_12, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public org.eclipse.emf.ecore.EObject next() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.emf.ecore.EObject nextTarget = preFetchedNextTarget;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (nextTarget == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("nextTarget = defaultStrategy.next();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("this.preFetchedNextTarget = null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return this.currentTarget = nextTarget;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_13, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public void startTraversal(java.util.Collection traversalRoots,\torg.eclipse.core.runtime.IProgressMonitor monitor) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("defaultStrategy.startTraversal(traversalRoots, monitor);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment_14 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_14, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private void prepareNextClientContext(org.eclipse.emf.ecore.EObject nextTarget) { ");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (nextTarget != null && currentTarget != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (nextTarget instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("final String id = ");
        CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
        _builder.append(_visualIDMethodCall, "\t\t\t\t");
        _builder.append("((org.eclipse.gmf.runtime.notation.View) nextTarget);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("String nextSemanticId = (id != null && java.util.Arrays.binarySearch(contextSwitchingIdentifiers, id) >= 0) ? id : null;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if ((currentSemanticCtxId != null && currentSemanticCtxId != nextSemanticId)");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t");
        _builder.append("|| (nextSemanticId != null && nextSemanticId != currentSemanticCtxId)) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("this.ctxChanged = true;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentSemanticCtxId = nextSemanticId;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("// context of domain model");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("this.ctxChanged = currentSemanticCtxId != null;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("currentSemanticCtxId = null;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("this.ctxChanged = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
