/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.transform;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.gmf.internal.bridge.transform.ITransformToGenModelOperation;
import org.eclipse.papyrus.gmf.internal.bridge.transform.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.transform.ModelConfigurationPage;
import org.eclipse.papyrus.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.papyrus.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.papyrus.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.papyrus.gmf.mappings.Mapping;

public class MapModelConfigurationPage
extends ModelConfigurationPage {
    public MapModelConfigurationPage(String pageId, ResourceLocationProvider rlp, ResourceSet resourceSet) {
        super(pageId, rlp, resourceSet);
        this.setTitle(Messages.TransformToGenModelWizard_title_mapmodel);
        this.setDescription(Messages.TransformToGenModelWizard_descr_mapmodel);
        this.setModelFileExtension("gmfmap");
    }

    @Override
    protected Resource doLoadResource(IProgressMonitor monitor) throws CoreException {
        ITransformToGenModelOperation o = this.getOperation();
        Mapping mapping = o.loadMappingModel(this.getURI(), monitor);
        return mapping.eResource();
    }

    ITransformToGenModelOperation getOperation() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        return wizard.getTransformOperation();
    }

    protected void resourceChanged() {
        super.resourceChanged();
        Diagnostic load = this.getOperation().getMapmodelValidationResult();
        if (load != null && (load.getSeverity() == 2 || load.getSeverity() == 1)) {
            this.setStatusMessage(TransformToGenModelOperation.getFirst(load));
        }
    }
}

