/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.attr;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.MapMode;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.gmfgraph.Point;
import org.eclipse.papyrus.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.Polyline;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class Decoration {
  @Inject
  private Figure xptFigure;
  
  @Inject
  private MapMode xptMapMode;
  
  @Inject
  private Shape xptShape;
  
  protected CharSequence _polylineAttrs(final PolylineDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _shapeAttrs = this.xptShape.shapeAttrs(it, figureVarName);
    _builder.append(_shapeAttrs);
    _builder.newLineIfNotEmpty();
    CharSequence _figureAttrs = this.xptFigure.figureAttrs(it, figureVarName);
    _builder.append(_figureAttrs);
    _builder.newLineIfNotEmpty();
    CharSequence _templatePoints = this.templatePoints(it, figureVarName);
    _builder.append(_templatePoints);
    _builder.newLineIfNotEmpty();
    CharSequence _scale = this.scale(it, figureVarName);
    _builder.append(_scale);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _polylineAttrs(final PolygonDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _shapeAttrs = this.xptShape.shapeAttrs(it, figureVarName);
    _builder.append(_shapeAttrs);
    _builder.newLineIfNotEmpty();
    CharSequence _figureAttrs = this.xptFigure.figureAttrs(it, figureVarName);
    _builder.append(_figureAttrs);
    _builder.newLineIfNotEmpty();
    CharSequence _templatePoints = this.templatePoints(it, figureVarName);
    _builder.append(_templatePoints);
    _builder.newLineIfNotEmpty();
    CharSequence _scale = this.scale(it, figureVarName);
    _builder.append(_scale);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence templatePoints(final Polyline it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getTemplate().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("org.eclipse.draw2d.geometry.PointList pl = new org.eclipse.draw2d.geometry.PointList();");
        _builder.newLine();
        {
          EList<Point> _template = it.getTemplate();
          for(final Point p : _template) {
            CharSequence _templatePoint = this.templatePoint(p, "pl");
            _builder.append(_templatePoint);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append(figureVarName);
        _builder.append(".setTemplate(pl);");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence templatePoint(final Point it, final String pointListVarName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(pointListVarName);
    _builder.append(".addPoint(");
    CharSequence _mapMode = this.xptMapMode.mapMode(it);
    _builder.append(_mapMode);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _scale(final PolylineDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getTemplate().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append(figureVarName);
        _builder.append(".setScale(");
        CharSequence _mapMode = this.xptMapMode.mapMode(Integer.valueOf(7));
        _builder.append(_mapMode);
        _builder.append(", ");
        CharSequence _mapMode_1 = this.xptMapMode.mapMode(Integer.valueOf(3));
        _builder.append(_mapMode_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _scale(final PolygonDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getTemplate().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append(figureVarName);
        _builder.append(".setScale(");
        CharSequence _mapMode = this.xptMapMode.mapMode(Integer.valueOf(7));
        _builder.append(_mapMode);
        _builder.append(", ");
        CharSequence _mapMode_1 = this.xptMapMode.mapMode(Integer.valueOf(3));
        _builder.append(_mapMode_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence polylineAttrs(final RealFigure it, final String figureVarName) {
    if (it instanceof PolygonDecoration) {
      return _polylineAttrs((PolygonDecoration)it, figureVarName);
    } else if (it instanceof PolylineDecoration) {
      return _polylineAttrs((PolylineDecoration)it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
  
  public CharSequence scale(final RealFigure it, final String figureVarName) {
    if (it instanceof PolygonDecoration) {
      return _scale((PolygonDecoration)it, figureVarName);
    } else if (it instanceof PolylineDecoration) {
      return _scale((PolylineDecoration)it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
}
