/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.diagram.editparts.Utils_qvto;
import xpt.diagram.editpolicies.TextSelectionEditPolicy;

@Singleton
@SuppressWarnings("all")
public class NodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private TextSelectionEditPolicy textSelection;
  
  public CharSequence className(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence constructor(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPoliciesBody(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new ");
    CharSequence _qualifiedClassName = this.textSelection.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new ");
    CharSequence _nodeLabelDragPolicyQualifiedClassName = this.nodeLabelDragPolicyQualifiedClassName(it.getDiagram());
    _builder.append(_nodeLabelDragPolicyQualifiedClassName);
    _builder.append("());");
    _builder.newLineIfNotEmpty();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    CharSequence _additionalEditPolicies = this.additionalEditPolicies(it);
    _builder.append(_additionalEditPolicies);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence additionalEditPolicies(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence refreshBounds(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void refreshBounds() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int width = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Width())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int height = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getSize_Height())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.geometry.Dimension size = new org.eclipse.draw2d.geometry.Dimension(width, height);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int x = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_X())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int y = ((Integer) getStructuralFeatureValue(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLocation_Y())).intValue();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.geometry.Point loc = new org.eclipse.draw2d.geometry.Point(x, y);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("((org.eclipse.gef.GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), new org.eclipse.draw2d.geometry.Rectangle(loc, size));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence handleNotificationEventBody(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Object feature = event.getFeature();");
    _builder.newLine();
    {
      boolean _isStoringChildPositions = this._utils_qvto.isStoringChildPositions(it.getNode());
      if (_isStoringChildPositions) {
        CharSequence _handleBounds = this.xptEditpartsCommon.handleBounds(it);
        _builder.append(_handleBounds);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _handleText = this.xptEditpartsCommon.handleText(it);
    _builder.append(_handleText);
    _builder.newLineIfNotEmpty();
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * since 3.1, old generated NodeLabelDragPolicy extracted to GMFT-runtime,
   * see org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy.
   * The next 2 DEFINE's are left here as a hook for possible AROUND's
   */
  public CharSequence nodeLabelDragPolicyQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.tooling.runtime.edit.policies.DefaultNodeLabelDragPolicy");
    return _builder;
  }
  
  public CharSequence nodeLabelDragPolicyClass(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
