/**
 * Copyright (c) 2006-2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package impl.diagram.editparts;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.viewmaps.modeledViewmapProducer;
import impl.parsers.expression_qvto;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModeledViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import parsers.ParserProvider;
import xpt.CodeStyle;
import xpt.Common;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editparts.EditPartFactory;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class TextAware {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  @Extension
  private ChoiceUtils_qvto _choiceUtils_qvto;
  
  @Inject
  @Extension
  private RuntimeLabelsSupport_qvto _runtimeLabelsSupport_qvto;
  
  @Inject
  @Extension
  private expression_qvto _expression_qvto;
  
  @Inject
  private modeledViewmapProducer xptModeledViewmapProducer;
  
  @Inject
  private ParserProvider xptParserProvider;
  
  @Inject
  private EditPartFactory xptEditPartFactory;
  
  @Inject
  private ElementTypes xptElementTypes;
  
  public CharSequence fields(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gef.tools.DirectEditManager manager;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.common.ui.services.parser.IParser parser;");
    _builder.newLine();
    _builder.newLine();
    {
      if ((this._choiceUtils_qvto.isOclChoiceLabel(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        _builder.append("private org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker.Registrator myOclRegistrator;");
        _builder.newLine();
      } else {
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.util.List<?> parserElements;");
        _builder.newLine();
      }
    }
    _builder.newLine();
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4);
    _builder.newLineIfNotEmpty();
    _builder.append("private String defaultText;\t");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate labelDelegate;");
    _builder.newLine();
    return _builder;
  }
  
  public Object methods(final GenCommonBase it, final boolean needsRefreshBounds, final boolean readOnly, final boolean useElementIcon, final Viewmap viewmap, final LabelModelFacet modelFacet, final GenCommonBase host, final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _labelTextHelper = this.getLabelTextHelper(it);
    _builder.append(_labelTextHelper, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setLabelTextHelper = this.setLabelTextHelper(it);
    _builder.append(_setLabelTextHelper, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _labelIconHelper = this.getLabelIconHelper(it);
    _builder.append(_labelIconHelper, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setLabelIconHelper = this.setLabelIconHelper(it);
    _builder.append(_setLabelIconHelper, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _labelSetter = this.labelSetter(it);
    _builder.append(_labelSetter, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _modelChildren = this.getModelChildren(it);
    _builder.append(_modelChildren, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _childBySemanticHint = this.getChildBySemanticHint(it);
    _builder.append(_childBySemanticHint, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _parserElement = this.getParserElement(it, modelFacet);
    _builder.append(_parserElement, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _labelIcon = this.getLabelIcon(it, useElementIcon, diagram);
    _builder.append(_labelIcon, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _labelText = this.getLabelText(it);
    _builder.append(_labelText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setLabelText = this.setLabelText(it, diagram);
    _builder.append(_setLabelText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _editText = this.getEditText(it);
    _builder.append(_editText, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isEditable = this.isEditable(it, Boolean.valueOf(readOnly));
    _builder.append(_isEditable, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _editTextValidator = this.getEditTextValidator(it);
    _builder.append(_editTextValidator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _completionProcessor = this.getCompletionProcessor(it);
    _builder.append(_completionProcessor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _parserOptions = this.getParserOptions(it);
    _builder.append(_parserOptions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _parser = this.getParser(it, modelFacet, diagram, host);
    _builder.append(_parser, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _manager = this.getManager(it, diagram, modelFacet);
    _builder.append(_manager, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setManager = this.setManager(it);
    _builder.append(_setManager, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _performDirectEdit = this.performDirectEdit(it);
    _builder.append(_performDirectEdit, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _performDirectEditAtPoint = this.performDirectEditAtPoint(it, modelFacet);
    _builder.append(_performDirectEditAtPoint, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      boolean _isChoiceLabel = this._choiceUtils_qvto.isChoiceLabel(modelFacet);
      boolean _not = (!_isChoiceLabel);
      if (_not) {
        CharSequence _performDirectEditWithInitialChar = this.performDirectEditWithInitialChar(it);
        _builder.append(_performDirectEditWithInitialChar);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _performDirectEditRequest = this.performDirectEditRequest(it, modelFacet);
    _builder.append(_performDirectEditRequest, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshVisuals = this.refreshVisuals(it, Boolean.valueOf(needsRefreshBounds));
    _builder.append(_refreshVisuals, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshLabel = this.refreshLabel(it, diagram);
    _builder.append(_refreshLabel, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshUnderline = this.refreshUnderline(it);
    _builder.append(_refreshUnderline, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshStrikeThrough = this.refreshStrikeThrough(it);
    _builder.append(_refreshStrikeThrough, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshFont = this.refreshFont(it);
    _builder.append(_refreshFont, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _refreshSelectionFeedback = this.refreshSelectionFeedback(it);
    _builder.append(_refreshSelectionFeedback, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setFontColor = this.setFontColor(it);
    _builder.append(_setFontColor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _addSemanticListeners = this.addSemanticListeners(it);
    _builder.append(_addSemanticListeners, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _removeSemanticListeners = this.removeSemanticListeners(it);
    _builder.append(_removeSemanticListeners, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _accessibleEditPart = this.getAccessibleEditPart(it);
    _builder.append(_accessibleEditPart, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fontStyleOwnerView = this.getFontStyleOwnerView(it, viewmap);
    _builder.append(_fontStyleOwnerView, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    {
      if ((this._choiceUtils_qvto.isOclChoiceLabelWithShowExpr(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
        CharSequence _oclTracker = this.getOclTracker(it);
        _builder.append(_oclTracker);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      if ((this._choiceUtils_qvto.isOclChoiceLabel(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
        CharSequence _oclRegistrator = this.getOclRegistrator(it);
        _builder.append(_oclRegistrator);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("  ");
    CharSequence _labelDelegate = this.getLabelDelegate(it);
    _builder.append(_labelDelegate, "  ");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.newLine();
    _builder.append("  ");
    CharSequence _adapter = this.getAdapter(it);
    _builder.append(_adapter, "  ");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelSetterName(final ParentAssignedViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _setterName = it.getSetterName();
      boolean _notEquals = (!Objects.equal(_setterName, null));
      if (_notEquals) {
        String _setterName_1 = it.getSetterName();
        _builder.append(_setterName_1);
      } else {
        _builder.append("setLabel");
      }
    }
    return _builder;
  }
  
  protected CharSequence _labelSetterName(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("setLabel");
    return _builder;
  }
  
  protected CharSequence _labelSetterName(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("setLabel");
    return _builder;
  }
  
  public CharSequence getLabelTextHelper(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected String getLabelTextHelper(org.eclipse.draw2d.IFigure figure) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (figure instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) figure).getText();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    {
      boolean _isVerticalLabel = this._runtimeLabelsSupport_qvto.isVerticalLabel(it);
      if (_isVerticalLabel) {
        _builder.append(" else if (figure instanceof ");
        String _verticalLabelFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("return ((");
        String _verticalLabelFQN_1 = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN_1, "\t\t\t");
        _builder.append(") figure).getText();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} ");
      }
    }
    _builder.append(" else if (figure instanceof org.eclipse.draw2d.Label) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.draw2d.Label) figure).getText();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getLabelDelegate().getText();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setLabelTextHelper(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLabelTextHelper(org.eclipse.draw2d.IFigure figure, String text) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (figure instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) figure).setText(text);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    {
      boolean _isVerticalLabel = this._runtimeLabelsSupport_qvto.isVerticalLabel(it);
      if (_isVerticalLabel) {
        _builder.append(" else if (figure instanceof ");
        String _verticalLabelFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("((");
        String _verticalLabelFQN_1 = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN_1, "\t\t\t");
        _builder.append(") figure).setText(text);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} ");
      }
    }
    _builder.append(" else if (figure instanceof org.eclipse.draw2d.Label) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.draw2d.Label) figure).setText(text);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getLabelDelegate().setText(text);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getLabelIconHelper(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.swt.graphics.Image getLabelIconHelper(org.eclipse.draw2d.IFigure figure) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (figure instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) figure).getIcon();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    {
      boolean _isVerticalLabel = this._runtimeLabelsSupport_qvto.isVerticalLabel(it);
      if (_isVerticalLabel) {
        _builder.append(" else if (figure instanceof ");
        String _verticalLabelFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("//icons are not supported for verical labels now");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} ");
      }
    }
    _builder.append(" else if (figure instanceof org.eclipse.draw2d.Label) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ((org.eclipse.draw2d.Label) figure).getIcon();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getLabelDelegate().getIcon(0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setLabelIconHelper(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLabelIconHelper(org.eclipse.draw2d.IFigure figure, org.eclipse.swt.graphics.Image icon) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (figure instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) figure).setIcon(icon);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} ");
    {
      boolean _isVerticalLabel = this._runtimeLabelsSupport_qvto.isVerticalLabel(it);
      if (_isVerticalLabel) {
        _builder.append(" else if (figure instanceof ");
        String _verticalLabelFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("//icons are not supported for verical labels now, nothing to do");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} ");
      }
    }
    _builder.append(" else if (figure instanceof org.eclipse.draw2d.Label) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.draw2d.Label) figure).setIcon(icon);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getLabelDelegate().setIcon(icon, 0);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getLabelDelegate(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate getLabelDelegate(){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (labelDelegate == null){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.draw2d.IFigure label = getFigure();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (label instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("labelDelegate = new org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel)label);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} ");
    {
      boolean _isVerticalLabel = this._runtimeLabelsSupport_qvto.isVerticalLabel(it);
      if (_isVerticalLabel) {
        _builder.append(" else if (label instanceof ");
        String _verticalLabelFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("\t\t");
        _builder.append("labelDelegate = new ");
        String _verticalLabelDelegateFQN = this._runtimeLabelsSupport_qvto.getVerticalLabelDelegateFQN();
        _builder.append(_verticalLabelDelegateFQN, "\t\t\t\t");
        _builder.append("((");
        String _verticalLabelFQN_1 = this._runtimeLabelsSupport_qvto.getVerticalLabelFQN();
        _builder.append(_verticalLabelFQN_1, "\t\t\t\t");
        _builder.append(")label); ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} ");
      }
    }
    _builder.append(" else {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("labelDelegate = new ");
    String _simpleLabelDelegateFQN = this._runtimeLabelsSupport_qvto.getSimpleLabelDelegateFQN();
    _builder.append(_simpleLabelDelegateFQN, "\t\t\t");
    _builder.append("((org.eclipse.draw2d.Label)label);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return labelDelegate;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAdapter(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public Object getAdapter(Class key) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate.class.equals(key)){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return getLabelDelegate();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getAdapter(key);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence labelSetter(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void ");
    CharSequence _labelSetterName = this.labelSetterName(it.getViewmap());
    _builder.append(_labelSetterName);
    _builder.append("(");
    CharSequence _labelSetterFigureClassName = this.labelSetterFigureClassName(it.getViewmap());
    _builder.append(_labelSetterFigureClassName);
    _builder.append(" figure) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("unregisterVisuals();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setFigure(figure);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("defaultText = getLabelTextHelper(figure);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("registerVisuals();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshVisuals();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _labelSetterFigureClassName(final ParentAssignedViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _notEquals = (!Objects.equal(_figureQualifiedClassName, null));
      if (_notEquals) {
        String _figureQualifiedClassName_1 = it.getFigureQualifiedClassName();
        _builder.append(_figureQualifiedClassName_1);
      } else {
        _builder.append("org.eclipse.draw2d.IFigure");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelSetterFigureClassName(final ModeledViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _viewmapFigureFQN = this.xptModeledViewmapProducer.viewmapFigureFQN(it);
    _builder.append(_viewmapFigureFQN);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _labelSetterFigureClassName(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.draw2d.IFigure");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getModelChildren(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _SuppressWarnings = this._codeStyle.SuppressWarnings(it, "\"rawtypes\"");
    _builder.append(_SuppressWarnings);
    _builder.newLineIfNotEmpty();
    _builder.append("protected java.util.List getModelChildren() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return java.util.Collections.EMPTY_LIST;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getChildBySemanticHint(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart getChildBySemanticHint(String semanticHint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getParserElement(final GenCommonBase it, final LabelModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.emf.ecore.EObject getParserElement() {");
    _builder.newLine();
    {
      boolean _equals = Objects.equal(modelFacet, null);
      if (_equals) {
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject element = resolveSemanticElement();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return element != null ? element : (org.eclipse.gmf.runtime.notation.View) getModel();");
        _builder.newLine();
      } else {
        _builder.append("\t");
        CharSequence _dispatch_getParserElement = this.dispatch_getParserElement(modelFacet);
        _builder.append(_dispatch_getParserElement, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _dispatch_getParserElement(final LabelModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return resolveSemanticElement();");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _dispatch_getParserElement(final DesignLabelModelFacet it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return (org.eclipse.gmf.runtime.notation.View) getModel();");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getLabelIcon(final GenCommonBase it, final boolean useElementIcon, final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.swt.graphics.Image getLabelIcon() {");
    _builder.newLine();
    {
      if (useElementIcon) {
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject parserElement = getParserElement();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (parserElement == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _qualifiedClassName = this.xptElementTypes.qualifiedClassName(diagram);
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".getImage(parserElement.eClass());");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getLabelText(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected String getLabelText() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String text = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject parserElement = getParserElement();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (parserElement != null && getParser() != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("text = getParser().getPrintString(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(parserElement),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("getParserOptions().intValue());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (text == null || text.length() == 0) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("text = defaultText;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return text;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setLabelText(final GenCommonBase it, final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setLabelText(String text) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setLabelTextHelper(getFigure(), text);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshSelectionFeedback();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditText(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getEditText() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getParserElement() == null || getParser() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return \"\"; ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getParser().getEditString(");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(getParserElement()),");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getParserOptions().intValue());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isEditable(final GenCommonBase it, final Boolean readOnly) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean isEditable() {");
    _builder.newLine();
    {
      if ((readOnly).booleanValue()) {
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return getParser() != null;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditTextValidator(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.jface.viewers.ICellEditorValidator getEditTextValidator() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new org.eclipse.jface.viewers.ICellEditorValidator() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String isValid(final Object value) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (value instanceof String) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final org.eclipse.emf.ecore.EObject element = getParserElement();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final org.eclipse.gmf.runtime.common.ui.services.parser.IParser parser = getParser();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus valid =");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus) getEditingDomain().runExclusive(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("new org.eclipse.emf.transaction.RunnableWithResult.Impl<org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus>() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setResult(parser.isValidEditString(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(element), (String) value));");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("return valid.getCode() == org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.EDITABLE ? null : valid.getMessage();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} catch (InterruptedException ie) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ie.printStackTrace();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// shouldn\'t get here");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getCompletionProcessor(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.jface.text.contentassist.IContentAssistProcessor getCompletionProcessor() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getParserElement() == null || getParser() == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getParser().getCompletionProcessor(new org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter(getParserElement()));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getParserOptions(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions getParserOptions() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions.NONE;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getParser(final GenCommonBase it, final LabelModelFacet modelFacet, final GenDiagram diagram, final GenCommonBase host) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.ui.services.parser.IParser getParser() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (parser == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("parser = ");
    CharSequence _accessorCall = this.xptParserProvider.accessorCall(it, host, modelFacet, "getParserElement()");
    _builder.append(_accessorCall, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return parser;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getManager(final GenCommonBase it, final GenDiagram diagram, final LabelModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.tools.DirectEditManager getManager() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (manager == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setManager(new ");
    String _directManagerFQN = this._choiceUtils_qvto.getDirectManagerFQN(modelFacet);
    _builder.append(_directManagerFQN, "\t\t");
    _builder.append("(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("null,");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName = this.xptEditPartFactory.qualifiedClassName(diagram);
    _builder.append(_qualifiedClassName, "\t\t\t");
    _builder.append(".getTextCellEditorLocator(this)));");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return manager;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setManager(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setManager(org.eclipse.gef.tools.DirectEditManager manager) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("this.manager = manager;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performDirectEdit(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void performDirectEdit() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getManager().show();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performDirectEditAtPoint(final GenCommonBase it, final LabelModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void performDirectEdit(org.eclipse.draw2d.geometry.Point eventLocation) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getManager().getClass() == ");
    String _directManagerFQN = this._choiceUtils_qvto.getDirectManagerFQN(modelFacet);
    _builder.append(_directManagerFQN, "\t");
    _builder.append(".class) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("((");
    String _directManagerFQN_1 = this._choiceUtils_qvto.getDirectManagerFQN(modelFacet);
    _builder.append(_directManagerFQN_1, "\t\t");
    _builder.append(") getManager()).show(eventLocation.getSWTPoint());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performDirectEditWithInitialChar(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void performDirectEdit(char initialCharacter) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (getManager() instanceof org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager) getManager()).show(initialCharacter);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else //");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("performDirectEdit();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence performDirectEditRequest(final GenCommonBase it, final LabelModelFacet modelFacet) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void performDirectEditRequest(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("final org.eclipse.gef.Request theRequest = request;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getEditingDomain().runExclusive(new Runnable() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (isActive() && isEditable()) {");
    _builder.newLine();
    {
      boolean _isChoiceLabel = this._choiceUtils_qvto.isChoiceLabel(modelFacet);
      boolean _not = (!_isChoiceLabel);
      if (_not) {
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("if (theRequest.getExtendedData().get(org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants.REQ_DIRECTEDIT_EXTENDEDDATA_INITIAL_CHAR) instanceof Character) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t\t");
        _builder.append("Character initialChar = (Character) theRequest.getExtendedData().get(org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants.REQ_DIRECTEDIT_EXTENDEDDATA_INITIAL_CHAR);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("\t\t");
        _builder.append("performDirectEdit(initialChar.charValue());");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} else ");
      }
    }
    _builder.append(" if ((theRequest instanceof org.eclipse.gef.requests.DirectEditRequest) && (getEditText().equals(getLabelText()))) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.gef.requests.DirectEditRequest editRequest = (org.eclipse.gef.requests.DirectEditRequest) theRequest;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("performDirectEdit(editRequest.getLocation());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("performDirectEdit();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("e.printStackTrace();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshVisuals(final GenCommonBase it, final Boolean needsRefreshBounds) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshVisuals() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.refreshVisuals();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshLabel();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshFont();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshFontColor();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshUnderline();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshStrikeThrough();");
    _builder.newLine();
    {
      if ((needsRefreshBounds).booleanValue()) {
        _builder.append("\t");
        _builder.append("refreshBounds();");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshLabel(final GenCommonBase it, final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshLabel() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setLabelTextHelper(getFigure(), getLabelText());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setLabelIconHelper(getFigure(), getLabelIcon());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("refreshSelectionFeedback();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshUnderline(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshUnderline() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.FontStyle style =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.FontStyle) getFontStyleOwnerView().getStyle(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (style != null && getFigure() instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) getFigure()).setTextUnderline(style.isUnderline());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshStrikeThrough(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshStrikeThrough() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.FontStyle style =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.FontStyle) getFontStyleOwnerView().getStyle(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (style != null && getFigure() instanceof org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel) getFigure()).setTextStrikeThrough(style.isStrikeThrough());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshFont(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void refreshFont() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.FontStyle style =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.FontStyle) getFontStyleOwnerView().getStyle(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFontStyle());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (style != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.graphics.FontData fontData = new org.eclipse.swt.graphics.FontData(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("style.getFontName(), style.getFontHeight(),");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(style.isBold() ? org.eclipse.swt.SWT.BOLD : org.eclipse.swt.SWT.NORMAL) |");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("(style.isItalic() ? org.eclipse.swt.SWT.ITALIC : org.eclipse.swt.SWT.NORMAL));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setFont(fontData);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence refreshSelectionFeedback(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private void refreshSelectionFeedback() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("requestEditPolicyFeedbackRefresh(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("requestEditPolicyFeedbackRefresh(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private void requestEditPolicyFeedbackRefresh(String editPolicyKey) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object editPolicy = getEditPolicy(editPolicyKey);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (editPolicy instanceof org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy)editPolicy).refreshFeedback();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setFontColor(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setFontColor(org.eclipse.swt.graphics.Color color) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getFigure().setForegroundColor(color);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence addSemanticListeners(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void addSemanticListeners() {");
    _builder.newLine();
    {
      if ((this._choiceUtils_qvto.isOclChoiceLabel(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
        {
          if ((this._choiceUtils_qvto.isOclChoiceLabelWithShowExpr(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
            _builder.append("org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker tracker = getTracker();");
            _builder.newLine();
            _builder.append("tracker.initialize(resolveSemanticElement());");
            _builder.newLine();
            _builder.append("tracker.installListeners(getEditingDomain(), this, getOclRegistrator());");
            _builder.newLine();
          } else {
            _builder.append("super.addSemanticListeners();");
            _builder.newLine();
          }
        }
        {
          boolean _isOclChoiceLabel = this._choiceUtils_qvto.isOclChoiceLabel(it);
          if (_isOclChoiceLabel) {
            _builder.append("((org.eclipse.gmf.tooling.runtime.parsers.OclChoiceParser) getParser()).installListeners(this, getOclRegistrator());");
            _builder.newLine();
          }
        }
      } else {
        _builder.append("if (getParser() instanceof org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.emf.ecore.EObject element = resolveSemanticElement();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("parserElements = ((org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser) getParser()).getSemanticElementsBeingParsed(element);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (int i = 0; i < parserElements.size(); i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addListenerFilter(\"SemanticModel\" + i, this, (org.eclipse.emf.ecore.EObject) parserElements.get(i)); ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append(_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.addSemanticListeners();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence removeSemanticListeners(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void removeSemanticListeners() {");
    _builder.newLine();
    {
      if ((this._choiceUtils_qvto.isOclChoiceLabel(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
        {
          boolean _isOclChoiceLabel = this._choiceUtils_qvto.isOclChoiceLabel(it);
          if (_isOclChoiceLabel) {
            _builder.append("((org.eclipse.gmf.tooling.runtime.parsers.OclChoiceParser) getParser()).uninstallListeners();");
            _builder.newLine();
          }
        }
        {
          if ((this._choiceUtils_qvto.isOclChoiceLabelWithShowExpr(it) || this._expression_qvto.isViewExpressionDefinedAndOcl(it))) {
            _builder.append("getTracker().uninstallListeners();\t");
            _builder.newLine();
          } else {
            _builder.append("super.removeSemanticListeners();");
            _builder.newLine();
          }
        }
      } else {
        _builder.append("if (parserElements != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (int i = 0; i < parserElements.size(); i++) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("removeListenerFilter(\"SemanticModel\" + i); ");
        CharSequence _nonNLS = this._common.nonNLS();
        _builder.append(_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.removeSemanticListeners();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getAccessibleEditPart(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.AccessibleEditPart getAccessibleEditPart() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (accessibleEP == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("accessibleEP = new AccessibleGraphicalEditPart() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void getName(org.eclipse.swt.accessibility.AccessibleEvent e) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("e.result = getLabelTextHelper(getFigure());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return accessibleEP;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getFontStyleOwnerView(final GenCommonBase it, final Viewmap viewmap) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("private org.eclipse.gmf.runtime.notation.View getFontStyleOwnerView() {");
    _builder.newLine();
    {
      boolean _isFixedFont = this._viewmapAttributesUtils_qvto.isFixedFont(viewmap);
      if (_isFixedFont) {
        _builder.append(" ");
        _builder.append("return (org.eclipse.gmf.runtime.notation.View) getModel();");
        _builder.newLine();
      } else {
        _builder.append(" ");
        _builder.append("return getPrimaryView();");
        _builder.newLine();
      }
    }
    _builder.append(" ");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getOclTracker(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker getTracker() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ((org.eclipse.gmf.tooling.runtime.ocl.tracker.HasOclTracker) getParser()).getOclTracker();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getOclRegistrator(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker.Registrator getOclRegistrator() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (myOclRegistrator == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myOclRegistrator = new org.eclipse.gmf.tooling.runtime.ocl.tracker.OclTracker.Registrator() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("public void registerListener(String filterId, org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener listener, org.eclipse.emf.ecore.EObject element) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("addListenerFilter(filterId, listener, element);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
    _builder.append(_overrideI_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("public void unregisterListener(String filterId) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("removeListenerFilter(filterId);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myOclRegistrator;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence labelSetterName(final Viewmap it) {
    if (it instanceof ModeledViewmap) {
      return _labelSetterName((ModeledViewmap)it);
    } else if (it instanceof ParentAssignedViewmap) {
      return _labelSetterName((ParentAssignedViewmap)it);
    } else if (it != null) {
      return _labelSetterName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence labelSetterFigureClassName(final Viewmap it) {
    if (it instanceof ModeledViewmap) {
      return _labelSetterFigureClassName((ModeledViewmap)it);
    } else if (it instanceof ParentAssignedViewmap) {
      return _labelSetterFigureClassName((ParentAssignedViewmap)it);
    } else if (it != null) {
      return _labelSetterFigureClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence dispatch_getParserElement(final LabelModelFacet it) {
    if (it instanceof DesignLabelModelFacet) {
      return _dispatch_getParserElement((DesignLabelModelFacet)it);
    } else if (it != null) {
      return _dispatch_getParserElement(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
