/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838, Migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.updater;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;
  
  public String getLinkMethodSuffix(final UpdaterLinkType type) {
    if (type != null) {
      switch (type) {
        case CONTAINED:
          return "Contained";
        case INCOMING:
          return "Incoming";
        case OUTGOING:
          return "Outgoing";
        default:
          throw new IllegalArgumentException(("Unknown updaterLinkType: " + type));
      }
    } else {
      throw new IllegalArgumentException(("Unknown updaterLinkType: " + type));
    }
  }
  
  public Iterable<GenLink> computeContainedLinks(final GenClass metaClass, final GenDiagram diagram) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this._linkUtils_qvto.canBeContainer(link, metaClass));
      }
    };
    return IterableExtensions.<GenLink>filter(diagram.getLinks(), _function);
  }
  
  public Iterable<GenLink> computeOutgoingLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(linkEnd.getGenOutgoingLinks().contains(link));
      }
    };
    return IterableExtensions.<GenLink>filter(linkEnd.getDiagram().getLinks(), _function);
  }
  
  public Iterable<GenLink> computeIncomingLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(linkEnd.getGenIncomingLinks().contains(link));
      }
    };
    return IterableExtensions.<GenLink>filter(linkEnd.getDiagram().getLinks(), _function);
  }
  
  public Iterable<GenLink> getAllContainedLinks(final GenDiagram diagram) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
          @Override
          public Boolean apply(final GenCommonBase commonBase) {
            return Boolean.valueOf(Utils_qvto.this._linkUtils_qvto.canBeContainer(link, Utils_qvto.this.getMetaClass(commonBase)));
          }
        };
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenCommonBase>notEmpty(IterableExtensions.<GenCommonBase>filter(Utils_qvto.this.getAllSemanticElements(diagram), _function)));
      }
    };
    return IterableExtensions.<GenLink>filter(diagram.getLinks(), _function);
  }
  
  public Iterable<GenLink> getAllIncomingLinks(final GenDiagram diagram) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenLinkEnd>notEmpty(link.getTargets()));
      }
    };
    return IterableExtensions.<GenLink>filter(diagram.getLinks(), _function);
  }
  
  public Iterable<GenLink> getAllOutgoingLinks(final GenDiagram diagram) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this.isOutgoingLink(link));
      }
    };
    final Function1<GenLink, Boolean> _function_1 = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenLinkEnd>notEmpty(link.getSources()));
      }
    };
    return IterableExtensions.<GenLink>filter(IterableExtensions.<GenLink>filter(diagram.getLinks(), _function), _function_1);
  }
  
  public boolean isOutgoingLink(final GenLink link) {
    return ((!Objects.equal(null, link.getModelFacet())) && this.isOutgoingLinkModelFacet(link.getModelFacet()));
  }
  
  protected boolean _isOutgoingLinkModelFacet(final LinkModelFacet facet) {
    return true;
  }
  
  protected boolean _isOutgoingLinkModelFacet(final TypeLinkModelFacet facet) {
    GenFeature _sourceMetaFeature = facet.getSourceMetaFeature();
    return (!Objects.equal(null, _sourceMetaFeature));
  }
  
  public Iterable<GenLinkEnd> getAllSemanticDiagramElements(final GenDiagram diagram) {
    LinkedList<GenLinkEnd> result = CollectionLiterals.<GenLinkEnd>newLinkedList();
    result.addAll(diagram.getAllNodes());
    result.addAll(diagram.getLinks());
    final Function1<GenLinkEnd, Boolean> _function = new Function1<GenLinkEnd, Boolean>() {
      @Override
      public Boolean apply(final GenLinkEnd linkEnd) {
        GenClass _metaClass = Utils_qvto.this.getMetaClass(linkEnd);
        return Boolean.valueOf((!Objects.equal(_metaClass, null)));
      }
    };
    return IterableExtensions.<GenLinkEnd>filter(result, _function);
  }
  
  public Iterable<GenCommonBase> getAllSemanticElements(final GenDiagram diagram) {
    GenClass _domainDiagramElement = diagram.getDomainDiagramElement();
    boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
    if (_notEquals) {
      LinkedList<GenCommonBase> result = CollectionLiterals.<GenCommonBase>newLinkedList(diagram);
      Iterables.<GenCommonBase>addAll(result, this.getAllSemanticDiagramElements(diagram));
      return result;
    } else {
      return Iterables.<GenCommonBase>filter(this.getAllSemanticDiagramElements(diagram), GenCommonBase.class);
    }
  }
  
  protected GenClass _getMetaClass(final GenCommonBase some) {
    return null;
  }
  
  protected GenClass _getMetaClass(final GenDiagram some) {
    return some.getDomainDiagramElement();
  }
  
  protected GenClass _getMetaClass(final GenNode some) {
    GenClass _xifexpression = null;
    TypeModelFacet _modelFacet = some.getModelFacet();
    boolean _equals = Objects.equal(_modelFacet, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      _xifexpression = some.getModelFacet().getMetaClass();
    }
    return _xifexpression;
  }
  
  protected GenClass _getMetaClass(final GenLink some) {
    GenClass _xifexpression = null;
    LinkModelFacet _modelFacet = some.getModelFacet();
    boolean _equals = Objects.equal(_modelFacet, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      _xifexpression = this.getMetaClass(some.getModelFacet());
    }
    return _xifexpression;
  }
  
  protected GenClass _getMetaClass(final LinkModelFacet facet) {
    return null;
  }
  
  protected GenClass _getMetaClass(final TypeLinkModelFacet facet) {
    return facet.getMetaClass();
  }
  
  public boolean hasSemanticChildren(final GenContainerBase container) {
    return ((!container.isSansDomain()) && this._common_qvto.<GenNode>notEmpty(container.getContainedNodes()));
  }
  
  protected GenClass _getModelElementType(final GenContainerBase base) {
    return null;
  }
  
  protected GenClass _getModelElementType(final GenDiagram diagram) {
    return diagram.getDomainDiagramElement();
  }
  
  protected GenClass _getModelElementType(final GenCompartment compartment) {
    return this.getModelElementType(compartment.getNode());
  }
  
  protected GenClass _getModelElementType(final GenNode node) {
    return node.getModelFacet().getMetaClass();
  }
  
  public Set<GenFeature> getSemanticChildrenChildFeatures(final GenContainerBase containerBase) {
    LinkedHashSet<GenFeature> result = CollectionLiterals.<GenFeature>newLinkedHashSet();
    final Function1<GenNode, GenFeature> _function = new Function1<GenNode, GenFeature>() {
      @Override
      public GenFeature apply(final GenNode node) {
        return node.getModelFacet().getChildMetaFeature();
      }
    };
    Iterables.<GenFeature>addAll(result, IterableExtensions.<GenNode, GenFeature>map(this.getNonPhantomSemanticChildren(containerBase), _function));
    return result;
  }
  
  public Set<GenFeature> getSemanticChildrenContainmentFeatures(final GenContainerBase containerBase) {
    LinkedHashSet<GenFeature> result = CollectionLiterals.<GenFeature>newLinkedHashSet();
    final Function1<GenNode, GenFeature> _function = new Function1<GenNode, GenFeature>() {
      @Override
      public GenFeature apply(final GenNode node) {
        return node.getModelFacet().getContainmentMetaFeature();
      }
    };
    Iterables.<GenFeature>addAll(result, IterableExtensions.<GenNode, GenFeature>map(this.getNonPhantomSemanticChildren(containerBase), _function));
    return result;
  }
  
  public Iterable<GenNode> getSemanticChildren(final GenContainerBase containerBase, final GenFeature childMetaFeature) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode node) {
        GenFeature _childMetaFeature = node.getModelFacet().getChildMetaFeature();
        return Boolean.valueOf(Objects.equal(_childMetaFeature, childMetaFeature));
      }
    };
    return IterableExtensions.<GenNode>filter(this.getNonPhantomSemanticChildren(containerBase), _function);
  }
  
  public Iterable<GenNode> getNonPhantomSemanticChildren(final GenContainerBase containerBase) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode node) {
        boolean _isPhantomElement = node.getModelFacet().isPhantomElement();
        return Boolean.valueOf((!_isPhantomElement));
      }
    };
    return IterableExtensions.<GenNode>filter(this.getSemanticChildren(containerBase), _function);
  }
  
  public boolean hasPhantomNodes(final GenDiagram it) {
    boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(this.getPhantomNodes(it));
    if (_notEmpty) {
      return true;
    }
    EList<GenNode> _allNodes = it.getAllNodes();
    for (final GenNode node : _allNodes) {
      boolean _notEmpty_1 = this._common_qvto.<GenNode>notEmpty(this.getPhantomNodes(node));
      if (_notEmpty_1) {
        return true;
      }
    }
    return false;
  }
  
  protected Iterable<GenNode> _getPhantomNodes(final GenContainerBase it) {
    return CollectionLiterals.<GenNode>newLinkedList();
  }
  
  protected Iterable<GenNode> _getPhantomNodes(final GenNode it) {
    return this.getPhantomNodesForContainers(it);
  }
  
  protected Iterable<GenNode> _getPhantomNodes(final GenDiagram it) {
    return this.getPhantomNodesForContainers(it);
  }
  
  public Iterable<GenNode> getPhantomNodesForContainers(final GenContainerBase it) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode node) {
        return Boolean.valueOf(node.getModelFacet().isPhantomElement());
      }
    };
    return IterableExtensions.<GenNode>filter(this.getSemanticChildren(it), _function);
  }
  
  public Iterable<GenNode> getSemanticChildren(final GenContainerBase containerBase) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode node) {
        TypeModelFacet _modelFacet = node.getModelFacet();
        return Boolean.valueOf((!Objects.equal(_modelFacet, null)));
      }
    };
    return IterableExtensions.<GenNode>filter(containerBase.getContainedNodes(), _function);
  }
  
  /**
   * @return true when children share same metaclass
   */
  public boolean hasConformableSemanticChildren(final GenContainerBase containerBase) {
    final Function1<GenNode, GenClass> _function = new Function1<GenNode, GenClass>() {
      @Override
      public GenClass apply(final GenNode child) {
        return child.getModelFacet().getMetaClass();
      }
    };
    Iterable<GenClass> childMetaClasses = IterableExtensions.<GenNode, GenClass>map(this.getSemanticChildren(containerBase), _function);
    int _size = IterableExtensions.size(childMetaClasses);
    int _size_1 = IterableExtensions.<GenClass>toSet(childMetaClasses).size();
    return (_size != _size_1);
  }
  
  protected GenClass _getLinkEndType(final LinkModelFacet facet, final UpdaterLinkType type) {
    return null;
  }
  
  protected GenClass _getLinkEndType(final FeatureLinkModelFacet facet, final UpdaterLinkType type) {
    GenClass _switchResult = null;
    if (type != null) {
      switch (type) {
        case INCOMING:
          _switchResult = facet.getTargetType();
          break;
        case OUTGOING:
          _switchResult = facet.getSourceType();
          break;
        default:
          _switchResult = null;
          break;
      }
    } else {
      _switchResult = null;
    }
    return _switchResult;
  }
  
  protected GenClass _getLinkEndType(final TypeLinkModelFacet facet, final UpdaterLinkType type) {
    boolean _equals = Objects.equal(type, UpdaterLinkType.INCOMING);
    if (_equals) {
      return facet.getTargetType();
    }
    if ((Objects.equal(type, UpdaterLinkType.OUTGOING) && (!Objects.equal(facet.getSourceMetaFeature(), null)))) {
      return facet.getSourceType();
    }
    GenFeature _containmentMetaFeature = facet.getContainmentMetaFeature();
    boolean _equals_1 = Objects.equal(_containmentMetaFeature, null);
    if (_equals_1) {
      return null;
    }
    return facet.getContainmentMetaFeature().getGenClass();
  }
  
  public boolean isOutgoingLinkModelFacet(final LinkModelFacet facet) {
    if (facet instanceof TypeLinkModelFacet) {
      return _isOutgoingLinkModelFacet((TypeLinkModelFacet)facet);
    } else if (facet != null) {
      return _isOutgoingLinkModelFacet(facet);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(facet).toString());
    }
  }
  
  public GenClass getMetaClass(final EObject some) {
    if (some instanceof GenNode) {
      return _getMetaClass((GenNode)some);
    } else if (some instanceof GenDiagram) {
      return _getMetaClass((GenDiagram)some);
    } else if (some instanceof GenLink) {
      return _getMetaClass((GenLink)some);
    } else if (some instanceof TypeLinkModelFacet) {
      return _getMetaClass((TypeLinkModelFacet)some);
    } else if (some instanceof LinkModelFacet) {
      return _getMetaClass((LinkModelFacet)some);
    } else if (some instanceof GenCommonBase) {
      return _getMetaClass((GenCommonBase)some);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(some).toString());
    }
  }
  
  public GenClass getModelElementType(final GenContainerBase compartment) {
    if (compartment instanceof GenCompartment) {
      return _getModelElementType((GenCompartment)compartment);
    } else if (compartment instanceof GenNode) {
      return _getModelElementType((GenNode)compartment);
    } else if (compartment instanceof GenDiagram) {
      return _getModelElementType((GenDiagram)compartment);
    } else if (compartment != null) {
      return _getModelElementType(compartment);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(compartment).toString());
    }
  }
  
  public Iterable<GenNode> getPhantomNodes(final GenContainerBase it) {
    if (it instanceof GenNode) {
      return _getPhantomNodes((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getPhantomNodes((GenDiagram)it);
    } else if (it != null) {
      return _getPhantomNodes(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public GenClass getLinkEndType(final LinkModelFacet facet, final UpdaterLinkType type) {
    if (facet instanceof FeatureLinkModelFacet) {
      return _getLinkEndType((FeatureLinkModelFacet)facet, type);
    } else if (facet instanceof TypeLinkModelFacet) {
      return _getLinkEndType((TypeLinkModelFacet)facet, type);
    } else if (facet != null) {
      return _getLinkEndType(facet, type);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(facet, type).toString());
    }
  }
}
