/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Michael Golubev (Montages) - initial API and implementation
 *   Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.plugin;

import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class build {
  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("build.properties");
    return _builder;
  }
  
  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence build(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _includes = this.includes(it);
    _builder.append(_includes);
    _builder.newLineIfNotEmpty();
    CharSequence _compileOrders = this.compileOrders(it);
    _builder.append(_compileOrders);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence includes(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("bin.includes = .,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("icons/,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("META-INF/,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("plugin.xml,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("plugin.properties,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append("messages.properties,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append(".options");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileOrders(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("jars.compile.order = .");
    _builder.newLine();
    _builder.append("source.. = src/");
    _builder.newLine();
    _builder.append("output.. = bin/");
    _builder.newLine();
    return _builder;
  }
}
