/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.command;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AddAppliedStereotypePropertiesToDisplayCommand
extends RecordingCommand {
    private Property property;
    private Stereotype stereotype;
    private View view;
    private TransactionalEditingDomain domain;
    private String location;
    private static StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    private static StereotypeDisplayCommandExecution commandHelper = StereotypeDisplayCommandExecution.getInstance();

    public AddAppliedStereotypePropertiesToDisplayCommand(TransactionalEditingDomain domain, View view, Property property, Stereotype stereotype, String location) {
        super(domain, "Display a Stereotype Property");
        this.property = property;
        this.stereotype = stereotype;
        this.domain = domain;
        this.view = view;
        this.location = location;
    }

    protected void doExecute() {
        DecorationNode propertyView = null;
        switch (StereotypeLocationEnum.valueOf(this.location)) {
            case IN_BRACE: {
                propertyView = helper.getStereotypePropertyInBrace(this.view, this.stereotype, this.property);
                break;
            }
            case IN_COMMENT: {
                propertyView = helper.getStereotypePropertyInComment(this.view, this.stereotype, this.property);
                break;
            }
            case IN_COMPARTMENT: {
                propertyView = helper.getStereotypeProperty(this.view, this.stereotype, this.property);
            }
        }
        commandHelper.setUserVisibility(this.domain, (View)propertyView, true);
    }
}

