/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.helper;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class EventCreationHelper {
    public static final String NATURAL_LANGUAGE = "Natural language";
    public static final String EVENTS = "events";
    Transition transition;

    public EventCreationHelper(Transition transition) {
        this.transition = transition;
    }

    public Package getEventPackage() {
        Package np = this.transition.getNearestPackage();
        int i = 0;
        while (true) {
            PackageableElement ep;
            String name = EVENTS;
            if (i > 0) {
                name = String.valueOf(name) + i;
            }
            if ((ep = np.getPackagedElement(name)) instanceof Package) {
                return (Package)ep;
            }
            if (ep == null) {
                return np.createNestedPackage(name);
            }
            ++i;
        }
    }

    public CallEvent getOrCreateCallEvent(Operation operation, boolean renameExisting) {
        String name = "CE - " + operation.getClass_().getName() + " - " + operation.getName();
        Package eventPkg = this.getEventPackage();
        for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
            if (!(existingPE instanceof CallEvent) || ((CallEvent)existingPE).getOperation() != operation) continue;
            if (renameExisting) {
                ((CallEvent)existingPE).setName(name);
            }
            return (CallEvent)existingPE;
        }
        CallEvent ce = UMLFactory.eINSTANCE.createCallEvent();
        ce.setOperation(operation);
        ce.setName(name);
        eventPkg.getPackagedElements().add((Object)ce);
        return ce;
    }

    public SignalEvent getOrCreateSignalEvent(Signal signal, boolean renameExisting) {
        Package eventPkg = this.getEventPackage();
        String name = "SE - " + signal.getName();
        for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
            if (!(existingPE instanceof SignalEvent) || ((SignalEvent)existingPE).getSignal() != signal) continue;
            if (renameExisting) {
                ((SignalEvent)existingPE).setName(name);
            }
            return (SignalEvent)existingPE;
        }
        SignalEvent se = UMLFactory.eINSTANCE.createSignalEvent();
        se.setSignal(signal);
        se.setName(name);
        eventPkg.getPackagedElements().add((Object)se);
        return se;
    }

    public ChangeEvent getOrCreateChangeEvent(String opaqueChangeExpr, boolean renameExisting) {
        Package eventPkg = this.getEventPackage();
        String name = "CE - " + opaqueChangeExpr;
        for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
            EList bodies;
            ValueSpecification vs;
            if (!(existingPE instanceof ChangeEvent) || !((vs = ((ChangeEvent)existingPE).getChangeExpression()) instanceof OpaqueExpression) || (bodies = ((OpaqueExpression)vs).getBodies()).size() <= 0 || !((String)bodies.get(0)).equals(opaqueChangeExpr)) continue;
            if (renameExisting) {
                ((ChangeEvent)existingPE).setName(name);
            }
            return (ChangeEvent)existingPE;
        }
        ChangeEvent ce = UMLFactory.eINSTANCE.createChangeEvent();
        OpaqueExpression changeExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
        changeExpression.getLanguages().add((Object)NATURAL_LANGUAGE);
        changeExpression.getBodies().add((Object)opaqueChangeExpr);
        ce.setChangeExpression((ValueSpecification)changeExpression);
        ce.setName(name);
        eventPkg.getPackagedElements().add((Object)ce);
        return ce;
    }

    public TimeEvent getOrCreateTimeEvent(String opaqueWhen, boolean isRelative, boolean renameExisting) {
        Package eventPkg = this.getEventPackage();
        String name = "TE - " + opaqueWhen;
        for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
            EList bodies;
            ValueSpecification vs;
            if (!(existingPE instanceof TimeEvent) || !((vs = ((TimeEvent)existingPE).getWhen().getExpr()) instanceof OpaqueExpression) || (bodies = ((OpaqueExpression)vs).getBodies()).size() <= 0 || !((String)bodies.get(0)).equals(opaqueWhen)) continue;
            if (renameExisting) {
                ((TimeEvent)existingPE).setName(name);
            }
            return (TimeEvent)existingPE;
        }
        TimeEvent te = UMLFactory.eINSTANCE.createTimeEvent();
        OpaqueExpression timeExpressionExp = UMLFactory.eINSTANCE.createOpaqueExpression();
        timeExpressionExp.getLanguages().add((Object)NATURAL_LANGUAGE);
        timeExpressionExp.getBodies().add((Object)opaqueWhen);
        TimeExpression timeExpression = UMLFactory.eINSTANCE.createTimeExpression();
        timeExpression.setExpr((ValueSpecification)timeExpressionExp);
        te.setWhen(timeExpression);
        te.setIsRelative(isRelative);
        te.setName(name);
        eventPkg.getPackagedElements().add((Object)te);
        return te;
    }
}

