/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.AbstractPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.ProjectManagementService;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;

public class BuildPropertiesChecker
extends AbstractPluginChecker {
    private static final String GENMODEL_EXTENSION = "genmodel";
    private static final String ECORE_EXTENSION = "ecore";
    private final Resource modelResource;
    private Function<? super IFile, ? extends Collection<? extends IResource>> dependenciesFunction;
    private OpaqueResourceProvider.EMF modelOpaqueResourceProvider;
    private OpaqueResourceProvider.XML pluginXMLOpaqueResourceProvider;

    public BuildPropertiesChecker(IProject project, IFile modelFile) {
        this(project, modelFile, (Resource)null);
    }

    public BuildPropertiesChecker(IProject project, IFile modelFile, String markerType) {
        this(project, modelFile, null, markerType);
    }

    public BuildPropertiesChecker(IProject project, IFile modelFile, Resource modelResource) {
        super(project, modelFile);
        this.modelResource = modelResource;
    }

    public BuildPropertiesChecker(IProject project, IFile modelFile, Resource modelResource, String markerType) {
        super(project, modelFile, markerType);
        this.modelResource = modelResource;
    }

    public BuildPropertiesChecker withEMFGeneratorModels() {
        return this.withDependencies(BuildPropertiesChecker::getEMFCodeGenDependencies);
    }

    public BuildPropertiesChecker withDependencies(Function<? super IFile, ? extends Collection<? extends IResource>> dependenciesFunction) {
        this.dependenciesFunction = dependenciesFunction;
        return this;
    }

    public BuildPropertiesChecker withReferencedResources(OpaqueResourceProvider.EMF opaqueReferenceProvider) {
        this.modelOpaqueResourceProvider = OpaqueResourceProvider.and(opaqueReferenceProvider, this.modelOpaqueResourceProvider);
        return this;
    }

    public BuildPropertiesChecker withReferencedResources(OpaqueResourceProvider.XML opaqueReferenceProvider) {
        this.pluginXMLOpaqueResourceProvider = OpaqueResourceProvider.and(opaqueReferenceProvider, this.pluginXMLOpaqueResourceProvider);
        return this;
    }

    @Override
    public void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.BuildPropertiesChecker_2, (Object)this.getModelFile().getName()), (int)1);
        if (subMonitor.isCanceled()) {
            return;
        }
        IBuildModel buildModel = ProjectManagementService.getPluginBuild(this.getProject());
        if (buildModel != null) {
            Set<IResource> requiredResources = this.computeRequiredResources((IResource)this.getModelFile());
            requiredResources.addAll(this.getCrossReferencedResources());
            requiredResources.addAll(this.getReferencedOpaqueResources(diagnostics));
            requiredResources.removeIf(Predicate.not(arg_0 -> ((IProject)this.getProject()).contains(arg_0)));
            IBuild build = buildModel.getBuild();
            IBuildEntry buildEntry = build.getEntry("bin.includes");
            String[] tokens = buildEntry.getTokens();
            int i = 0;
            while (i < tokens.length && !requiredResources.isEmpty()) {
                String token = tokens[i];
                Iterator<IResource> iter = requiredResources.iterator();
                while (iter.hasNext()) {
                    IResource next = iter.next();
                    String path = next.getProjectRelativePath().toString();
                    if (path.equals(token)) {
                        iter.remove();
                        break;
                    }
                    if (!path.startsWith(token)) continue;
                    if (token.endsWith("/")) {
                        iter.remove();
                        continue;
                    }
                    int prefixLength = token.length();
                    if (prefixLength >= path.length() || path.charAt(prefixLength) != '/') continue;
                    iter.remove();
                }
                ++i;
            }
            if (!requiredResources.isEmpty()) {
                ArrayList<BuildError> errors = new ArrayList<BuildError>(requiredResources.size());
                for (IResource next : requiredResources) {
                    errors.add(new BuildError(this.getMarkerType(), NLS.bind((String)Messages.BuildPropertiesChecker_3, (Object)next.getProjectRelativePath()), 4, "bin.includes", next.getProjectRelativePath().toString()));
                }
                this.reportErrors(diagnostics, errors);
            }
        }
        subMonitor.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    public static Collection<IResource> getEMFCodeGenDependencies(IFile modelFile) {
        String genModelPath;
        if (GENMODEL_EXTENSION.equals(modelFile.getFileExtension())) {
            return Collections.emptyList();
        }
        IProject project = modelFile.getProject();
        Optional<GenModel> maybeGenModel = BuildPropertiesChecker.loadGenModel(project, genModelPath = modelFile.getProjectRelativePath().removeFileExtension().addFileExtension(GENMODEL_EXTENSION).toString());
        if (maybeGenModel.isEmpty()) {
            return Collections.emptyList();
        }
        GenModel genModel = maybeGenModel.get();
        if (!genModel.getForeignModel().contains((Object)modelFile.getName())) {
            return Collections.emptyList();
        }
        if (ECORE_EXTENSION.equals(modelFile.getFileExtension())) {
            return List.of(project.getFile(genModelPath));
        }
        String ecorePath = BuildPropertiesChecker.ecoreFilePath(genModel);
        return List.of(project.getFile(genModelPath), project.getFile(ecorePath));
    }

    private static String ecoreFilePath(GenModel genModel) {
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        EPackageImpl ecoreImpl = (EPackageImpl)genPackage.getEcorePackage();
        URI ecoreURI = ecoreImpl.eResource().getURI();
        ArrayList segments = new ArrayList(ecoreURI.segmentsList());
        return String.join((CharSequence)"/", segments.subList(2, segments.size()));
    }

    private static Optional<GenModel> loadGenModel(IProject project, String genModelPath) {
        try {
            EObject root;
            Resource genModelResource;
            URI uri = URI.createPlatformPluginURI((String)(String.valueOf(project.getName()) + "/" + genModelPath), (boolean)true);
            ResourceSetImpl set = new ResourceSetImpl();
            set.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
            if (set.getURIConverter().exists(uri, null) && (genModelResource = set.getResource(uri, true)) != null && genModelResource.getContents().size() > 0 && (root = (EObject)genModelResource.getContents().get(0)) instanceof GenModel) {
                return Optional.of((GenModel)root);
            }
        }
        catch (Exception e) {
            Activator.log.error("Failed to load genmodel in Papyrus Build Checker.", (Throwable)e);
        }
        return Optional.empty();
    }

    private Set<IResource> computeRequiredResources(IResource root) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(root);
        IResource next = (IResource)queue.poll();
        while (next != null) {
            if (result.add(next) && this.dependenciesFunction != null && next instanceof IFile) {
                queue.addAll(this.dependenciesFunction.apply((IFile)((IFile)next)));
            }
            next = (IResource)queue.poll();
        }
        return result;
    }

    private Set<IResource> getCrossReferencedResources() {
        Set<Object> result = Set.of();
        if (this.modelResource != null) {
            Set<URI> xrefURIs = ModelDependenciesChecker.computeExternalCrossReferences(this.modelResource);
            result = xrefURIs.stream().map(this::getResource).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return result;
    }

    private IResource getResource(URI uri) {
        IResource result = null;
        if (this.modelResource != null) {
            uri = this.modelResource.getResourceSet().getURIConverter().normalize(uri);
        }
        if (uri.isPlatformResource()) {
            String uriPlatformString = uri.toPlatformString(true);
            result = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uriPlatformString));
        }
        return result;
    }

    private Set<IResource> getReferencedOpaqueResources(DiagnosticChain diagnostics) {
        IFile pluginXML;
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        Function<URI, IResource> resourceFunction = this::getResource;
        if (this.modelOpaqueResourceProvider != null && this.modelResource != null) {
            this.modelOpaqueResourceProvider.processModel(this.getProject(), this.getModelFile(), this.modelResource, diagnostics, resourceFunction.compose(OpaqueResourceProvider.ClassifiedURI::uri), result::add);
            result.remove(null);
        }
        if (this.pluginXMLOpaqueResourceProvider != null && (pluginXML = ProjectManagementService.getPluginXMLFile((IContainer)this.getProject())) != null) {
            this.pluginXMLOpaqueResourceProvider.processModel(this.getProject(), pluginXML, diagnostics, resourceFunction.compose(OpaqueResourceProvider.ClassifiedURI::uri), result::add);
            result.remove(null);
        }
        return result;
    }

    private void reportErrors(DiagnosticChain diagnostics, List<BuildError> errors) {
        IFile buildPropertiesFile = ProjectManagementService.getBuildFile((IContainer)this.getProject());
        BuildModel textBuildModel = this.prepareTextBuildModel(buildPropertiesFile);
        errors.stream().forEach(error -> this.reportBuildError(diagnostics, buildPropertiesFile, textBuildModel, error.type, error.message, error.severity, error.entry, error.missingValue));
    }

    private void reportBuildError(DiagnosticChain diagnostics, IFile buildFile, BuildModel textBuildModel, String type, String message, int severity, String entry, String missingValue) {
        Diagnostic diagnostic = textBuildModel != null ? this.createDiagnostic(buildFile, severity, 0, message, IPluginChecker2.markerType(type), IPluginChecker2.lineNumber(this.getLineNumber(textBuildModel.getBuild().getEntry(entry))), IPluginChecker2.problem(0xFF1000), IPluginChecker2.missingBinInclude(missingValue)) : this.createDiagnostic(buildFile, severity, 0, message, IPluginChecker2.markerType(type));
        diagnostics.add(diagnostic);
    }

    private BuildModel prepareTextBuildModel(IFile file) {
        BuildModel bm;
        block5: {
            IDocument doc;
            block4: {
                try {
                    doc = this.createDocument(file);
                    if (doc != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
            }
            bm = new BuildModel(doc, true);
            bm.load();
            if (bm.isLoaded()) break block5;
            return null;
        }
        return bm;
    }

    protected IDocument createDocument(IFile file) {
        if (!file.exists()) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return null;
        }
        try {
            manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
            ITextFileBuffer textBuf = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument document = textBuf.getDocument();
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
            return document;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    private int getLineNumber(IBuildEntry ibe) {
        if (!(ibe instanceof BuildEntry)) {
            return 0;
        }
        BuildEntry be = (BuildEntry)ibe;
        IDocument doc = ((BuildModel)be.getModel()).getDocument();
        try {
            int buildEntryLineNumber = doc.getLineOfOffset(be.getOffset()) + 1;
            return buildEntryLineNumber;
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
            return 0;
        }
    }

    private static class BuildError {
        public final String entry;
        public final int severity;
        public final String message;
        public final String type;
        public final String missingValue;

        public BuildError(String type, String message, int severity, String entry, String missingValue) {
            this.type = type;
            this.message = message;
            this.severity = severity;
            this.entry = entry;
            this.missingValue = missingValue;
        }
    }
}

