/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.validate.regexp;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.gmf.internal.validate.DebugOptions;
import org.eclipse.papyrus.gmf.internal.validate.DefUtils;
import org.eclipse.papyrus.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.papyrus.gmf.internal.validate.Messages;
import org.eclipse.papyrus.gmf.internal.validate.StatusCodes;
import org.eclipse.papyrus.gmf.internal.validate.Trace;
import org.eclipse.papyrus.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.papyrus.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.papyrus.gmf.internal.validate.expressions.IParseEnvironment;

class RegularExpressionAdapter
extends AbstractExpression {
    private Pattern pattern;
    private boolean isNegation;

    public RegularExpressionAdapter(String body, EClassifier context, IParseEnvironment extEnv, boolean isNegation) {
        super(body, context, extEnv);
        this.isNegation = isNegation;
        try {
            this.pattern = Pattern.compile(body);
            if (!(context instanceof EDataType)) {
                this.setStatus(GMFValidationPlugin.createStatus(2, 0, NLS.bind((String)Messages.expressionRequiresEDataTypeAsContext, (Object)this.getLanguage()), null));
            }
        }
        catch (PatternSyntaxException e) {
            this.setInvalidExprStatus(e);
        }
        catch (RuntimeException e) {
            this.setUnexpectedParseError(e);
        }
    }

    @Override
    public String getLanguage() {
        return this.isNegation ? "nregexp" : "regexp";
    }

    @Override
    public boolean isLooselyTyped() {
        return false;
    }

    @Override
    public boolean isAssignableTo(EClassifier ecoreType) {
        return ecoreType.isInstance((Object)Boolean.TRUE);
    }

    @Override
    public boolean isAssignableToElement(ETypedElement typedElement) {
        return typedElement.getEType() != null && this.isAssignableTo(typedElement.getEType());
    }

    @Override
    public EClassifier getResultType() {
        return DefUtils.getCanonicalEcorePackageClassifier((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject());
    }

    @Override
    protected Object doEvaluate(Object context) {
        if (this.pattern == null || context == null) {
            return null;
        }
        String contextInstance = null;
        if (context instanceof EDataType) {
            contextInstance = EcoreUtil.convertToString((EDataType)((EDataType)context), contextInstance);
        }
        Matcher matcher = this.pattern.matcher(String.valueOf(contextInstance));
        boolean matches = matcher.matches();
        return this.isNegation ? !matches : matches;
    }

    @Override
    protected Object doEvaluate(Object context, IEvaluationEnvironment extEnvironment) {
        return this.doEvaluate(context);
    }

    private void setInvalidExprStatus(Exception exception) {
        String message = MessageFormat.format(Messages.invalidExpressionBody, this.getBody(), exception.getLocalizedMessage());
        this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.INVALID_VALUE_EXPRESSION, message, exception));
        Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, exception);
    }

    private void setUnexpectedParseError(Exception e) {
        this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.UNEXPECTED_PARSE_ERROR, Messages.unexpectedExprParseError, e));
        GMFValidationPlugin.log(this.getStatus());
        Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, e);
    }
}

