/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.ui.providers.DelegatingPapyrusContentProvider;
import org.eclipse.papyrus.infra.ui.providers.ISemanticContentProviderFactory;

class CompositeSemanticContentProviderFactory
implements ISemanticContentProviderFactory {
    private final List<ISemanticContentProviderFactory> factories;

    CompositeSemanticContentProviderFactory(ISemanticContentProviderFactory first, ISemanticContentProviderFactory second) {
        this.factories = Arrays.asList(first, second);
    }

    private CompositeSemanticContentProviderFactory(CompositeSemanticContentProviderFactory composite, ISemanticContentProviderFactory other) {
        this.factories = this.concat(composite, other);
    }

    private final List<ISemanticContentProviderFactory> concat(CompositeSemanticContentProviderFactory composite, ISemanticContentProviderFactory other) {
        ArrayList<ISemanticContentProviderFactory> result;
        if (other instanceof CompositeSemanticContentProviderFactory) {
            List<ISemanticContentProviderFactory> otherFactories = ((CompositeSemanticContentProviderFactory)other).factories;
            result = new ArrayList(composite.factories.size() + otherFactories.size());
            result.addAll(composite.factories);
            result.addAll(otherFactories);
        } else {
            result = new ArrayList<ISemanticContentProviderFactory>(composite.factories.size() + 1);
            result.addAll(composite.factories);
            result.add(other);
        }
        return result;
    }

    @Override
    public ITreeContentProvider createSemanticContentProvider(ResourceSet resourceSet) {
        return DelegatingPapyrusContentProvider.compose(this.factories.stream().map(f -> f.createSemanticContentProvider(resourceSet)).collect(Collectors.toList()));
    }

    @Override
    public ISemanticContentProviderFactory compose(ISemanticContentProviderFactory other) {
        return new CompositeSemanticContentProviderFactory(this, other);
    }
}

